/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.concurrent.TimeUnit;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.EmailAccount;
import org.jclouds.glesys.domain.EmailAlias;
import org.jclouds.glesys.domain.EmailOverview;
import org.jclouds.glesys.domain.EmailOverviewDomain;
import org.jclouds.glesys.features.EmailAccountApi;
import org.jclouds.glesys.internal.BaseGleSYSApiLiveTest;
import org.jclouds.glesys.options.CreateAccountOptions;
import org.jclouds.glesys.options.UpdateAccountOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="EmailAccountApiLiveTest", singleThreaded=true)
public class EmailAccountApiLiveTest
extends BaseGleSYSApiLiveTest {
    private EmailAccountApi emailAccountApi;
    private String testDomain;
    private Predicate<Integer> emailAccountCounter;

    public EmailAccountApiLiveTest() {
        this.hostName = this.hostName + "-email";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.testDomain = this.hostName + ".test.jclouds.org";
        this.emailAccountApi = ((GleSYSApi)this.api).getEmailAccountApi();
        this.deleteAll();
        this.createDomain(this.testDomain);
        this.emailAccountCounter = Predicates2.retry((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer value) {
                return EmailAccountApiLiveTest.this.emailAccountApi.listDomain(EmailAccountApiLiveTest.this.testDomain).size() == value.intValue();
            }
        }, (long)180L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.emailAccountCounter.apply((Object)0));
    }

    @AfterClass(groups={"integration", "live"})
    public void tearDown() {
        this.deleteAll();
        super.tearDown();
    }

    private void deleteAll() {
        this.emailAccountApi.delete("test@" + this.testDomain);
        this.emailAccountApi.delete("test1@" + this.testDomain);
    }

    @Test
    public void testCreateEmail() {
        this.emailAccountApi.createWithPassword("test@" + this.testDomain, "password", new CreateAccountOptions[]{CreateAccountOptions.Builder.antiVirus((boolean)true).autorespond(true).autorespondMessage("out of office")});
        Assert.assertTrue((boolean)this.emailAccountCounter.apply((Object)1));
        this.emailAccountApi.createWithPassword("test1@" + this.testDomain, "password", new CreateAccountOptions[0]);
        Assert.assertTrue((boolean)this.emailAccountCounter.apply((Object)2));
    }

    @Test(dependsOnMethods={"testCreateEmail"})
    public void testAliases() {
        Assert.assertTrue((boolean)this.emailAccountApi.listAliasesInDomain(this.testDomain).isEmpty());
        EmailAlias alias = this.emailAccountApi.createAlias("test2@" + this.testDomain, "test@" + this.testDomain);
        Assert.assertEquals((String)alias.getAlias(), (String)("test2@" + this.testDomain));
        Assert.assertEquals((String)alias.getForwardTo(), (String)("test@" + this.testDomain));
        EmailAlias aliasFromList = (EmailAlias)Iterables.getOnlyElement((Iterable)this.emailAccountApi.listAliasesInDomain(this.testDomain));
        Assert.assertEquals((Object)aliasFromList, (Object)alias);
        EmailOverview overview = this.emailAccountApi.getOverview();
        Assert.assertEquals((int)1, (int)overview.getSummary().getAliases());
        alias = this.emailAccountApi.updateAlias("test2@" + this.testDomain, "test1@" + this.testDomain);
        overview = this.emailAccountApi.getOverview();
        Assert.assertEquals((int)1, (int)overview.getSummary().getAliases());
        aliasFromList = (EmailAlias)Iterables.getOnlyElement((Iterable)this.emailAccountApi.listAliasesInDomain(this.testDomain));
        Assert.assertEquals((Object)aliasFromList, (Object)alias);
        this.emailAccountApi.delete("test2@" + this.testDomain);
        overview = this.emailAccountApi.getOverview();
        Assert.assertEquals((int)0, (int)overview.getSummary().getAliases());
    }

    @Test(dependsOnMethods={"testCreateEmail"})
    public void testOverview() throws Exception {
        EmailOverview overview = this.emailAccountApi.getOverview();
        Assert.assertNotNull((Object)overview.getSummary());
        Assert.assertTrue((overview.getSummary().getAccounts() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((overview.getSummary().getAliases() > -1 ? 1 : 0) != 0);
        Assert.assertTrue((overview.getSummary().getMaxAccounts() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((overview.getSummary().getMaxAliases() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)overview.gets());
        Assert.assertFalse((boolean)overview.gets().isEmpty());
        EmailOverviewDomain domain = EmailOverviewDomain.builder().domain(this.testDomain).accounts(1).build();
        Assert.assertTrue((boolean)overview.gets().contains(domain));
    }

    @Test(dependsOnMethods={"testCreateEmail"})
    public void testListAccounts() throws Exception {
        FluentIterable accounts = this.emailAccountApi.listDomain(this.testDomain);
        Assert.assertTrue((accounts.size() >= 1 ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"testCreateEmail"})
    public void testUpdateAccount() throws Exception {
        FluentIterable accounts = this.emailAccountApi.listDomain(this.testDomain);
        for (EmailAccount account : accounts) {
            if (!account.getAccount().equals("test@" + this.testDomain)) continue;
            Assert.assertTrue((boolean)account.isAntiVirus());
        }
        this.emailAccountApi.update("test@" + this.testDomain, new UpdateAccountOptions[]{UpdateAccountOptions.Builder.antiVirus((boolean)false)});
        accounts = this.emailAccountApi.listDomain(this.testDomain);
        for (EmailAccount account : accounts) {
            if (!account.getAccount().equals("test@" + this.testDomain)) continue;
            Assert.assertFalse((boolean)account.isAntiVirus());
        }
    }
}

