/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;

public class GleSYSTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected String ip = "any";
    protected String rootPassword = null;
    protected int transferGB = 50;

    public GleSYSTemplateOptions clone() {
        GleSYSTemplateOptions options = new GleSYSTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof GleSYSTemplateOptions) {
            GleSYSTemplateOptions copy = (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(to);
            copy.ip(this.ip);
            copy.rootPassword(this.rootPassword);
            copy.transferGB(this.transferGB);
        }
    }

    public GleSYSTemplateOptions ip(String ip) {
        Preconditions.checkNotNull((Object)ip);
        Preconditions.checkArgument(("any".equals(ip) || InetAddresses.isInetAddress((String)ip) ? 1 : 0) != 0, (String)"ip %s is not valid", (Object[])new Object[]{ip});
        this.ip = ip;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public GleSYSTemplateOptions rootPassword(String rootPassword) {
        Preconditions.checkNotNull((Object)rootPassword, (Object)"root password cannot be null");
        this.rootPassword = rootPassword;
        return this;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public boolean hasRootPassword() {
        return this.rootPassword != null;
    }

    public GleSYSTemplateOptions transferGB(int transferGB) {
        Preconditions.checkArgument((transferGB >= 0 ? 1 : 0) != 0, (String)"transferGB value must be >= 0", (Object[])new Object[]{transferGB});
        this.transferGB = transferGB;
        return this;
    }

    public int getTransferGB() {
        return this.transferGB;
    }

    public GleSYSTemplateOptions blockOnPort(int port, int seconds) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public GleSYSTemplateOptions inboundPorts(int ... ports) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public GleSYSTemplateOptions authorizePublicKey(String publicKey) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public GleSYSTemplateOptions installPrivateKey(String privateKey) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public GleSYSTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public GleSYSTemplateOptions userMetadata(String key, String value) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public GleSYSTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public GleSYSTemplateOptions networks(Iterable<String> networks) {
        return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(super.networks(networks));
    }

    public Objects.ToStringHelper string() {
        Objects.ToStringHelper stringHelper = super.string();
        stringHelper.add("transferGB", this.transferGB);
        stringHelper.add("ip", (Object)this.ip);
        if (this.hasRootPassword()) {
            stringHelper.add("rootPasswordPresent", true);
        }
        return stringHelper;
    }

    public static class Builder {
        public static GleSYSTemplateOptions ip(String ip) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.ip(ip));
        }

        public static GleSYSTemplateOptions rootPassword(String rootPassword) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.rootPassword(rootPassword));
        }

        public static GleSYSTemplateOptions transferGB(int transferGB) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.transferGB(transferGB));
        }

        public static GleSYSTemplateOptions inboundPorts(int ... ports) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static GleSYSTemplateOptions blockOnPort(int port, int seconds) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static GleSYSTemplateOptions userMetadata(Map<String, String> userMetadata) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static GleSYSTemplateOptions userMetadata(String key, String value) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.userMetadata(key, value));
        }

        public static GleSYSTemplateOptions nodeNames(Iterable<String> nodeNames) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static GleSYSTemplateOptions networks(Iterable<String> networks) {
            GleSYSTemplateOptions options = new GleSYSTemplateOptions();
            return (GleSYSTemplateOptions)GleSYSTemplateOptions.class.cast(options.networks((Iterable)networks));
        }
    }
}

