/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Console {
    private final String host;
    private final int port;
    private final String protocol;
    private final String password;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromConsole(this);
    }

    @ConstructorProperties(value={"host", "port", "protocol", "password"})
    protected Console(String host, int port, String protocol, String password) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.port = port;
        this.protocol = (String)Preconditions.checkNotNull((Object)protocol, (Object)"protocol");
        this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.port, this.protocol});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Console that = (Console)Console.class.cast(obj);
        return Objects.equal((Object)this.host, (Object)that.host) && Objects.equal((Object)this.port, (Object)that.port) && Objects.equal((Object)this.protocol, (Object)that.protocol);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("host", (Object)this.host).add("port", this.port).add("protocol", (Object)this.protocol).add("password", (Object)this.password);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String host;
        protected int port;
        protected String protocol;
        protected String password;

        protected abstract T self();

        public T host(String host) {
            this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
            return this.self();
        }

        public T port(int port) {
            this.port = port;
            return this.self();
        }

        public T protocol(String protocol) {
            this.protocol = (String)Preconditions.checkNotNull((Object)protocol, (Object)"protocol");
            return this.self();
        }

        public T password(String password) {
            this.password = (String)Preconditions.checkNotNull((Object)password, (Object)"password");
            return this.self();
        }

        public Console build() {
            return new Console(this.host, this.port, this.protocol, this.password);
        }

        public T fromConsole(Console in) {
            return ((Builder)((Builder)((Builder)this.host(in.getHost())).port(in.getPort())).protocol(in.getProtocol())).password(in.getPassword());
        }
    }
}

