/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

@Beta
public class EmailOverviewDomain {
    private final String domain;
    private final int accounts;
    private final int aliases;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEmailOverviewDomain(this);
    }

    @ConstructorProperties(value={"domainname", "accounts", "aliases"})
    protected EmailOverviewDomain(String domain, int accounts, int aliases) {
        this.domain = (String)Preconditions.checkNotNull((Object)domain, (Object)"domain");
        this.accounts = accounts;
        this.aliases = aliases;
    }

    public String get() {
        return this.domain;
    }

    public int getAccounts() {
        return this.accounts;
    }

    public int getAliases() {
        return this.aliases;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domain});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailOverviewDomain that = (EmailOverviewDomain)EmailOverviewDomain.class.cast(obj);
        return Objects.equal((Object)this.domain, (Object)that.domain);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("domain", (Object)this.domain).add("accounts", this.accounts).add("aliases", this.aliases);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String domain;
        protected int accounts;
        protected int aliases;

        protected abstract T self();

        public T domain(String domain) {
            this.domain = (String)Preconditions.checkNotNull((Object)domain, (Object)"domain");
            return this.self();
        }

        public T accounts(int accounts) {
            this.accounts = accounts;
            return this.self();
        }

        public T aliases(int aliases) {
            this.aliases = aliases;
            return this.self();
        }

        public EmailOverviewDomain build() {
            return new EmailOverviewDomain(this.domain, this.accounts, this.aliases);
        }

        public T fromEmailOverviewDomain(EmailOverviewDomain in) {
            return ((Builder)((Builder)this.domain(in.get())).accounts(in.getAccounts())).aliases(in.getAliases());
        }
    }
}

