/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Ip {
    private final String ip;
    private final int version;
    private final double cost;
    private final String currency;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromIp(this);
    }

    @ConstructorProperties(value={"ipaddress", "version", "cost", "currency"})
    protected Ip(String ip, int version, double cost, String currency) {
        this.ip = (String)Preconditions.checkNotNull((Object)ip, (Object)"ip");
        this.version = version;
        this.cost = cost;
        this.currency = (String)Preconditions.checkNotNull((Object)currency, (Object)"currency");
    }

    public String getIp() {
        return this.ip;
    }

    public int getVersion() {
        return this.version;
    }

    public double getCost() {
        return this.cost;
    }

    public String getCurrency() {
        return this.currency;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ip, this.version, this.cost});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Ip that = (Ip)Ip.class.cast(obj);
        return Objects.equal((Object)this.ip, (Object)that.ip) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.cost, (Object)that.cost) && Objects.equal((Object)this.currency, (Object)that.currency);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("ip", (Object)this.ip).add("version", this.version).add("cost", this.cost).add("currency", (Object)this.currency);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String ip;
        protected int version;
        protected double cost;
        protected String currency;

        protected abstract T self();

        public T ip(String ip) {
            this.ip = (String)Preconditions.checkNotNull((Object)ip, (Object)"ip");
            return this.self();
        }

        protected T version(int version) {
            this.version = version;
            return this.self();
        }

        public T version4() {
            return this.version(4);
        }

        public T version6() {
            return this.version(6);
        }

        public T cost(double cost) {
            this.cost = cost;
            return this.self();
        }

        public T currency(String currency) {
            this.currency = currency;
            return this.self();
        }

        public Ip build() {
            return new Ip(this.ip, this.version, this.cost, this.currency);
        }

        public T fromIp(Ip in) {
            return ((Builder)((Builder)this.ip(in.getIp())).version(in.getVersion())).cost(in.getCost());
        }
    }
}

