/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class ServerSpec {
    private final String platform;
    private final String datacenter;
    private final int memorySizeMB;
    private final int diskSizeGB;
    private final String templateName;
    private final int cpuCores;
    private final int transferGB;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerSpec(this);
    }

    @ConstructorProperties(value={"platform", "datacenter", "memorySizeMB", "diskSizeGB", "templateName", "cpuCores", "transferGB"})
    protected ServerSpec(String platform, String datacenter, int memorySizeMB, int diskSizeGB, String templateName, int cpuCores, int transferGB) {
        this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
        this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
        this.memorySizeMB = memorySizeMB;
        this.diskSizeGB = diskSizeGB;
        this.templateName = (String)Preconditions.checkNotNull((Object)templateName, (Object)"templateName");
        this.cpuCores = cpuCores;
        this.transferGB = transferGB;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public int getMemorySizeMB() {
        return this.memorySizeMB;
    }

    public int getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public int getTransferGB() {
        return this.transferGB;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.platform, this.datacenter, this.memorySizeMB, this.diskSizeGB, this.templateName, this.cpuCores, this.transferGB});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerSpec that = (ServerSpec)ServerSpec.class.cast(obj);
        return Objects.equal((Object)this.platform, (Object)that.platform) && Objects.equal((Object)this.datacenter, (Object)that.datacenter) && Objects.equal((Object)this.memorySizeMB, (Object)that.memorySizeMB) && Objects.equal((Object)this.diskSizeGB, (Object)that.diskSizeGB) && Objects.equal((Object)this.templateName, (Object)that.templateName) && Objects.equal((Object)this.cpuCores, (Object)that.cpuCores) && Objects.equal((Object)this.transferGB, (Object)that.transferGB);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("platform", (Object)this.platform).add("datacenter", (Object)this.datacenter).add("memorySizeMB", this.memorySizeMB).add("diskSizeGB", this.diskSizeGB).add("templateName", (Object)this.templateName).add("cpuCores", this.cpuCores).add("transferGB", this.transferGB);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String platform;
        protected String datacenter;
        protected int memorySizeMB;
        protected int diskSizeGB;
        protected String templateName;
        protected int cpuCores;
        protected int transferGB;

        protected abstract T self();

        public T platform(String platform) {
            this.platform = (String)Preconditions.checkNotNull((Object)platform, (Object)"platform");
            return this.self();
        }

        public T datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this.self();
        }

        public T memorySizeMB(int memorySizeMB) {
            this.memorySizeMB = memorySizeMB;
            return this.self();
        }

        public T diskSizeGB(int diskSizeGB) {
            this.diskSizeGB = diskSizeGB;
            return this.self();
        }

        public T templateName(String templateName) {
            this.templateName = (String)Preconditions.checkNotNull((Object)templateName, (Object)"templateName");
            return this.self();
        }

        public T cpuCores(int cpuCores) {
            this.cpuCores = cpuCores;
            return this.self();
        }

        public T transferGB(int transferGB) {
            this.transferGB = transferGB;
            return this.self();
        }

        public ServerSpec build() {
            return new ServerSpec(this.platform, this.datacenter, this.memorySizeMB, this.diskSizeGB, this.templateName, this.cpuCores, this.transferGB);
        }

        public T fromServerSpec(ServerSpec in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.platform(in.getPlatform())).datacenter(in.getDatacenter())).memorySizeMB(in.getMemorySizeMB())).diskSizeGB(in.getDiskSizeGB())).templateName(in.getTemplateName())).cpuCores(in.getCpuCores())).transferGB(in.getTransferGB());
        }
    }
}

