/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.ArgDecl;
import arq.cmdline.CmdLineArgs;
import java.util.Iterator;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestCmdLine
extends BaseTest {
    @Test
    public void test_Simple1() {
        String[] args = new String[]{""};
        CmdLineArgs cl = new CmdLineArgs(args);
        cl.process();
    }

    @Test
    public void test_Flag1() {
        String[] args = new String[]{""};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(false, "-a", new String[0]);
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue((String)"-a argument found", (!cl.contains(argA) ? 1 : 0) != 0);
    }

    @Test
    public void test_Flag2() {
        String[] args = new String[]{"-a"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(false, "-a", new String[0]);
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue((String)"No -a argument found", (boolean)cl.contains(argA));
    }

    @Test
    public void test_Flag3() {
        String[] args = new String[]{"-a", "filename"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(false, "-a", new String[0]);
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue((String)"No -a argument found", (boolean)cl.contains(argA));
    }

    @Test
    public void test_Arg1() {
        String[] args = new String[]{""};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(true, "-arg", new String[0]);
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue((String)"-arg argument found", (!cl.contains(argA) ? 1 : 0) != 0);
    }

    @Test
    public void test_Arg2() {
        String[] args = new String[]{"-arg=ARG", "filename"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(true, "arg", new String[0]);
        cl.add(argA);
        cl.process();
        TestCmdLine.assertTrue((String)"No -arg= argument found", (boolean)cl.contains(argA));
        TestCmdLine.assertEquals((String)"", (Object)cl.getValue(argA), (Object)"ARG");
        TestCmdLine.assertEquals((String)"", (Object)cl.getArg("arg").getValue(), (Object)"ARG");
    }

    @Test
    public void test_nArg1() {
        String[] args = new String[]{"-arg=V1", "--arg=V2", "-v"};
        CmdLineArgs cl = new CmdLineArgs(args);
        ArgDecl argA = new ArgDecl(true, "-arg", new String[0]);
        cl.add(argA);
        ArgDecl argV = new ArgDecl(false, "-v", new String[0]);
        cl.add(argV);
        cl.process();
        TestCmdLine.assertTrue((String)"No -arg= argument found", (boolean)cl.contains(argA));
        Iterator iter = cl.getValues("arg").iterator();
        TestCmdLine.assertEquals((String)"Argument 1", iter.next(), (Object)"V1");
        TestCmdLine.assertEquals((String)"Argument 2", iter.next(), (Object)"V2");
    }
}

