/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.ParameterizedSparqlString;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.jena.iri.IRIFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestParameterizedSparqlString {
    private void test(ParameterizedSparqlString query, String[] expected, String[] notExpected) {
        String command = query.toString();
        for (String x : expected) {
            Assert.assertTrue((boolean)command.contains(x));
        }
        for (String x : notExpected) {
            Assert.assertFalse((boolean)command.contains(x));
        }
    }

    private Query testAsQuery(ParameterizedSparqlString query) {
        return query.asQuery();
    }

    private UpdateRequest testAsUpdate(ParameterizedSparqlString update) {
        return update.asUpdate();
    }

    @Test
    public void test_param_string_constructor_1() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        Assert.assertEquals((Object)"", (Object)query.getCommandText());
    }

    @Test
    public void test_param_string_constructor_2() {
        ParameterizedSparqlString query = new ParameterizedSparqlString((String)null);
        Assert.assertEquals((Object)"", (Object)query.getCommandText());
    }

    @Test
    public void test_param_string_constructor_3() {
        ParameterizedSparqlString query = new ParameterizedSparqlString("", "http://example.org");
        Assert.assertEquals((Object)"http://example.org", (Object)query.getBaseUri());
    }

    @Test
    public void test_param_string_constructor_4() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource((String)"http://example.org");
        map.add("s", (RDFNode)r);
        ParameterizedSparqlString query = new ParameterizedSparqlString("", map);
        Assert.assertEquals((Object)r.asNode(), (Object)query.getParam("s"));
    }

    @Test
    public void test_param_string_constructor_5() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource((String)"http://example.org");
        map.add("s", (RDFNode)r);
        ParameterizedSparqlString query = new ParameterizedSparqlString(map);
        Assert.assertEquals((Object)r.asNode(), (Object)query.getParam("s"));
    }

    @Test
    public void test_param_string_constructor_6() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource((String)"http://example.org");
        map.add("s", (RDFNode)r);
        Literal l = ResourceFactory.createPlainLiteral((String)"example");
        map.add("o", (RDFNode)l);
        ParameterizedSparqlString query = new ParameterizedSparqlString("", map);
        Assert.assertEquals((Object)r.asNode(), (Object)query.getParam("s"));
        Assert.assertEquals((Object)l.asNode(), (Object)query.getParam("o"));
    }

    @Test
    public void test_param_string_constructor_7() {
        QuerySolutionMap map = new QuerySolutionMap();
        Resource r = ResourceFactory.createResource((String)"http://example.org");
        map.add("s", (RDFNode)r);
        Literal l = ResourceFactory.createPlainLiteral((String)"example");
        map.add("o", (RDFNode)l);
        ParameterizedSparqlString query = new ParameterizedSparqlString(map);
        Assert.assertEquals((Object)r.asNode(), (Object)query.getParam("s"));
        Assert.assertEquals((Object)l.asNode(), (Object)query.getParam("o"));
    }

    @Test
    public void test_param_string_constructor_8() {
        PrefixMappingImpl prefixes = new PrefixMappingImpl();
        prefixes.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString query = new ParameterizedSparqlString("", (PrefixMapping)prefixes);
        Assert.assertEquals((Object)prefixes.getNsPrefixURI("ex"), (Object)query.getNsPrefixURI("ex"));
    }

    @Test
    public void test_param_string_constructor_9() {
        PrefixMappingImpl prefixes = new PrefixMappingImpl();
        prefixes.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString query = new ParameterizedSparqlString((PrefixMapping)prefixes);
        Assert.assertEquals((Object)prefixes.getNsPrefixURI("ex"), (Object)query.getNsPrefixURI("ex"));
    }

    @Test
    public void test_param_string_iri_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        this.test(query, new String[]{"<http://example.org>"}, new String[]{"?s"});
    }

    @Test
    public void test_param_string_iri_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("p", "http://example.org");
        this.test(query, new String[]{"<http://example.org>"}, new String[]{"?p"});
    }

    @Test
    public void test_param_string_iri_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("o", "http://example.org");
        this.test(query, new String[]{"<http://example.org>"}, new String[]{"?o"});
    }

    @Test
    public void test_param_string_iri_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . ?s a ?type }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        this.test(query, new String[]{"<http://example.org>"}, new String[]{"?s"});
    }

    @Test
    public void test_param_string_iri_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        this.test(query, new String[]{"<http://example.org>", "<http://predicate>"}, new String[]{"?s", "?p"});
    }

    @Test
    public void test_param_string_bnode_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "_:blankNodeID");
        this.test(query, new String[]{"<_:blankNodeID>"}, new String[]{"?s"});
    }

    @Test
    public void test_param_string_bnode_2() {
        String cmdText = "INSERT { GRAPH <target> { ?node a:p ?o . } } WHERE { ?node a:p ?o . }";
        ParameterizedSparqlString update = new ParameterizedSparqlString(cmdText);
        update.setIri("node", "_:blankNodeID");
        this.test(update, new String[]{"<_:blankNodeID>"}, new String[]{"?node"});
    }

    @Test
    public void test_param_string_bnode_3() {
        Model model = ModelFactory.createDefaultModel();
        Resource bnode = model.createResource();
        bnode.addProperty(RDF.type, (RDFNode)OWL.Thing);
        Assert.assertEquals((long)1L, (long)model.size());
        Dataset ds = DatasetFactory.create((Model)model);
        ParameterizedSparqlString pq = new ParameterizedSparqlString();
        pq.setCommandText("SELECT * WHERE { ?s ?p ?o }");
        pq.setIri("s", "_:" + bnode.getId());
        Query q = pq.asQuery();
        try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Dataset)ds);){
            ResultSet rset = qe.execSelect();
            Assert.assertEquals((long)1L, (long)ResultSetFormatter.consume((ResultSet)rset));
        }
        ParameterizedSparqlString s = new ParameterizedSparqlString();
        s.setCommandText("INSERT { ?o ?p ?s } WHERE { ?s ?p ?o }");
        s.setIri("s", "_:" + bnode.getId());
        UpdateRequest query = s.asUpdate();
        UpdateProcessor proc = UpdateExecutionFactory.create((UpdateRequest)query, (GraphStore)GraphStoreFactory.create((Dataset)ds));
        proc.execute();
        Assert.assertEquals((long)1L, (long)model.listStatements(bnode, null, (RDFNode)null).toList().size());
        Assert.assertEquals((long)0L, (long)model.listStatements(null, null, (RDFNode)bnode).toList().size());
    }

    @Test
    public void test_param_string_mixed_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", true);
        this.test(query, new String[]{"<http://example.org>", "<http://predicate>", "true"}, new String[]{"?s", "?p", "?o"});
    }

    @Test
    public void test_param_string_string_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", "test");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_string_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", "A \"test\" string");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A \\\"test\\\" string\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_string_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", "Show me the $!");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"Show me the $!\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_string_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", "A multi\nline string");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A multi\\nline string\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_string_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", "A tabby\tstring");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A tabby\\tstring\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_string_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", "A test's test");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"A test\\'s test\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_string_7() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("p", "http://predicate");
        query.setLiteral("o", "test a\\b");
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test a\\\\b\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_boolean_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", true);
        this.test(query, new String[]{"true"}, new String[]{"?o", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", false);
        this.test(query, new String[]{"false"}, new String[]{"?o", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.toString()));
        this.test(query, new String[]{"xyz", XSD.xboolean.toString()}, new String[]{"?o"});
    }

    @Test
    public void test_param_string_boolean_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, true);
        this.test(query, new String[]{"true"}, new String[]{"? ", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, false);
        this.test(query, new String[]{"false"}, new String[]{"? ", XSD.xboolean.toString()});
    }

    @Test
    public void test_param_string_boolean_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.toString()));
        this.test(query, new String[]{"xyz", XSD.xboolean.toString()}, new String[]{"? "});
    }

    @Test
    public void test_param_string_int_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", 1234);
        this.test(query, new String[]{"1234"}, new String[]{"?o", XSD.integer.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_int_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", 3000000000L);
        this.test(query, new String[]{"3000000000"}, new String[]{"?o", XSD.integer.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_int_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.integer.toString()));
        this.test(query, new String[]{"xyz", XSD.integer.toString()}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_int_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, 1234);
        this.test(query, new String[]{"1234"}, new String[]{"? ", XSD.integer.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_int_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, 3000000000L);
        this.test(query, new String[]{"3000000000"}, new String[]{"? ", XSD.integer.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_int_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.integer.toString()));
        this.test(query, new String[]{"xyz", XSD.integer.toString()}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_double_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", 123.4);
        this.test(query, new String[]{"123.4", XSD.xdouble.toString()}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_double_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", 1.23E7);
        this.test(query, new String[]{"1.23E7"}, new String[]{"?o", XSD.xdouble.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_double_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xdouble.toString()));
        this.test(query, new String[]{"xyz", XSD.xdouble.toString()}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_double_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, 123.4);
        this.test(query, new String[]{"123.4", XSD.xdouble.toString()}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_double_5() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, 1.23E7);
        this.test(query, new String[]{"1.23E7"}, new String[]{"? ", XSD.xdouble.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_double_6() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xdouble.toString()));
        this.test(query, new String[]{"xyz", XSD.xdouble.toString()}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_float_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", 123.4f);
        this.test(query, new String[]{"123.4", XSD.xfloat.toString()}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_float_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, 123.4f);
        this.test(query, new String[]{"123.4", XSD.xfloat.toString()}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_date_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        Calendar dt = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        dt.set(2012, 1, 24, 12, 0, 0);
        query.setLiteral("o", dt);
        this.test(query, new String[]{"2012-02-24T12:00:00", XSD.dateTime.toString()}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_date_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.dateTime.toString()));
        this.test(query, new String[]{"xyz", XSD.dateTime.toString()}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_date_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        Calendar dt = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        dt.set(2012, 1, 24, 12, 0, 0);
        query.setLiteral(0, dt);
        this.test(query, new String[]{"2012-02-24T12:00:00", XSD.dateTime.toString()}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_date_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, "xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.dateTime.toString()));
        this.test(query, new String[]{"xyz", XSD.dateTime.toString()}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_lang_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", "hello", "en");
        this.test(query, new String[]{"hello", "@en"}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_lang_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("o", "bonjour", "fr");
        this.test(query, new String[]{"bonjour", "@fr"}, new String[]{"?o"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_lang_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, "hello", "en");
        this.test(query, new String[]{"hello", "@en"}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_lang_4() {
        String cmdText = "SELECT * WHERE { ?s ?p ? }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral(0, "bonjour", "fr");
        this.test(query, new String[]{"bonjour", "@fr"}, new String[]{"? "});
        this.testAsQuery(query);
    }

    @Test(expected=QueryException.class)
    public void test_param_string_bad_1() {
        String cmdText = "Not a query";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        this.testAsQuery(query);
    }

    @Test(expected=QueryException.class)
    public void test_param_string_simple_bad_1() {
        String cmdText = "SELECT ?s WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        this.test(query, new String[]{"<http://example.org>"}, new String[]{"?s"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_precedence_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setIri("s", "http://alternate.org");
        this.test(query, new String[]{"<http://alternate.org>"}, new String[]{"?s", "<http://example.org>"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_precedence_2() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri(0, "http://example.org");
        query.setIri(0, "http://alternate.org");
        this.test(query, new String[]{"<http://alternate.org>"}, new String[]{"? ", "<http://example.org>"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_name_collision_1() {
        String cmdText = "SELECT * WHERE { ?a ?ab ?abc }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("a", "http://example.org");
        this.test(query, new String[]{"<http://example.org>", "?ab", "?abc"}, new String[]{"?a "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_name_collision_2() {
        String cmdText = "SELECT * WHERE { ?abc ?ab ?a. }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("a", "http://example.org");
        this.test(query, new String[]{"<http://example.org>", "?ab", "?abc"}, new String[]{"?a "});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_name_collision_3() {
        String cmdText = "PREFIX ex: <http://example.org/vocab#> SELECT * WHERE { ?s ex:name ?name }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setLiteral("name", "Bob");
        this.test(query, new String[]{"Bob"}, new String[]{"?name", "ex:Bob"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_clear_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.clearParam("s");
        this.test(query, new String[]{"?s"}, new String[]{"<http://example.org>"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_clear_2() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.clearParams();
        this.test(query, new String[]{"?s"}, new String[]{"<http://example.org>"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_clear_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri("s", "http://example.org");
        query.setParam("s", (Node)null);
        this.test(query, new String[]{"?s"}, new String[]{"<http://example.org>"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_clear_4() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri(0, "http://example.org");
        query.clearParam(0);
        this.test(query, new String[]{"? "}, new String[]{"<http://example.org>"});
    }

    @Test
    public void test_param_string_clear_5() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri(0, "http://example.org");
        query.clearParams();
        this.test(query, new String[]{"? "}, new String[]{"<http://example.org>"});
    }

    @Test
    public void test_param_string_clear_6() {
        String cmdText = "SELECT * WHERE { ? ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setIri(0, "http://example.org");
        query.setParam(0, (Node)null);
        this.test(query, new String[]{"? "}, new String[]{"<http://example.org>"});
    }

    @Test
    public void test_param_string_prefixes_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setNsPrefix("ex", "http://example.org");
        this.test(query, new String[]{"PREFIX", "ex:", "<http://example.org>"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_prefixes_2() {
        String cmdText = "SELECT * WHERE { ?s ex:predicate ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setNsPrefix("ex", "http://example.org");
        this.test(query, new String[]{"PREFIX", "ex:", "<http://example.org>", "ex:predicate"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test(expected=QueryException.class)
    public void test_param_string_prefixes_bad_1() {
        String cmdText = "SELECT * WHERE { ?s ex:predicate ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        this.test(query, new String[]{"ex:predicate"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_base_1() {
        String cmdText = "SELECT * WHERE { ?s <#predicate> ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setBaseUri("http://example.org");
        this.test(query, new String[]{"BASE", "<http://example.org>"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_base_bad_1() {
        String cmdText = "SELECT * WHERE { ?s <#predicate> ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        this.test(query, new String[0], new String[]{"BASE", "<http://example.org>"});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_copy_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        ParameterizedSparqlString copy = query.copy();
        Assert.assertEquals((Object)cmdText, (Object)copy.getCommandText());
    }

    @Test
    public void test_param_string_copy_2() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.setIri("x", "http://example.org/original");
        ParameterizedSparqlString copy = query.copy();
        copy.setIri("x", "http://example.org/copy");
        Assert.assertEquals((Object)"http://example.org/original", (Object)query.getParam("x").toString());
        Assert.assertFalse((boolean)"http://example.org/copy".equals(query.getParam("x").toString()));
        Assert.assertEquals((Object)"http://example.org/copy", (Object)copy.getParam("x").toString());
        Assert.assertFalse((boolean)"http://example.org/original".equals(copy.getParam("x").toString()));
    }

    @Test
    public void test_param_string_copy_3() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString copy = query.copy();
        Assert.assertEquals((Object)"http://example.org", (Object)copy.getNsPrefixURI("ex"));
    }

    @Test
    public void test_param_string_copy_4() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.setBaseUri("http://example.org");
        ParameterizedSparqlString copy = query.copy();
        Assert.assertEquals((Object)"http://example.org", (Object)copy.getBaseUri());
    }

    @Test
    public void test_param_string_copy_5() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.setIri("x", "http://example.org/original");
        ParameterizedSparqlString copy = query.copy(false);
        Assert.assertEquals((Object)"http://example.org/original", (Object)query.getParam("x").toString());
        Assert.assertEquals(null, (Object)copy.getParam("x"));
    }

    @Test
    public void test_param_string_copy_6() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.setNsPrefix("ex", "http://example.org");
        ParameterizedSparqlString copy = query.copy(true, true, false);
        Assert.assertFalse((boolean)"http://example.org".equals(copy.getNsPrefixURI("ex")));
    }

    @Test
    public void test_param_string_copy_7() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.setIri(0, "http://example.org/original");
        ParameterizedSparqlString copy = query.copy();
        copy.setIri(0, "http://example.org/copy");
        Assert.assertEquals((Object)"http://example.org/original", (Object)query.getParam(0).toString());
        Assert.assertFalse((boolean)"http://example.org/copy".equals(query.getParam(0).toString()));
        Assert.assertEquals((Object)"http://example.org/copy", (Object)copy.getParam(0).toString());
        Assert.assertFalse((boolean)"http://example.org/original".equals(copy.getParam(0).toString()));
    }

    @Test
    public void test_param_string_copy_8() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.setIri(0, "http://example.org/original");
        ParameterizedSparqlString copy = query.copy(false);
        Assert.assertEquals((Object)"http://example.org/original", (Object)query.getParam(0).toString());
        Assert.assertEquals(null, (Object)copy.getParam(0));
    }

    @Test
    public void test_param_string_append_1() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ?o }");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "?o"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_2() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.append(true);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "true"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_3() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.append(123);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_4() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.append(123L);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_5() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.append(1.23E7);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "1.23E7"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_iri_1() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ");
        query.appendIri("http://example.org");
        query.append(" ?o }");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "<http://example.org>", "?o"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_iri_2() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ");
        query.appendIri(IRIFactory.iriImplementation().construct("http://example.org"));
        query.append(" ?o }");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "<http://example.org>", "?o"}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_boolean_1() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral(true);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "true"}, new String[]{XSD.xboolean.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_boolean_2() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral("xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.toString()));
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "xyz", XSD.xboolean.toString()}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_integer_1() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral(123);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[]{XSD.integer.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_integer_2() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral("xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.integer.toString()));
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "xyz", XSD.integer.toString()}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_integer_3() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral(123L);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "123"}, new String[]{XSD.integer.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_double_1() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral(1.23E7);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "1.23E7"}, new String[]{XSD.xdouble.toString()});
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_double_2() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral(1.23);
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "1.23", XSD.xdouble.toString()}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_append_double_3() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT *");
        query.append('\n');
        query.append("WHERE { ?s ?p ");
        query.appendLiteral("xyz", TypeMapper.getInstance().getSafeTypeByName(XSD.xdouble.toString()));
        query.append("}");
        this.test(query, new String[]{"SELECT", "*", "\n", "WHERE", "?s", "?p", "xyz", XSD.xdouble.toString()}, new String[0]);
        this.testAsQuery(query);
    }

    @Test
    public void test_param_string_positional_1() {
        ParameterizedSparqlString query = new ParameterizedSparqlString();
        query.append("SELECT * WHERE { ? ?p ?o }");
        query.setParam(0, NodeFactory.createURI((String)"http://example.org"));
        this.test(query, new String[]{"<http://example.org>"}, new String[]{"? "});
    }

    @Test
    public void test_param_string_positional_2() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setParam(0, NodeFactory.createURI((String)"http://example.org"));
        query.setParam(1, NodeFactory.createURI((String)"http://predicate"));
        query.setParam(2, NodeFactory.createLiteral((String)"test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_positional_3() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setParam(0, NodeFactory.createLiteral((String)"with ? mark"));
        query.setParam(1, NodeFactory.createURI((String)"http://predicate"));
        query.setParam(2, NodeFactory.createLiteral((String)"test"));
        Assert.assertEquals((Object)"SELECT * WHERE { \"with ? mark\" <http://predicate> \"test\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_positional_4() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setParam(0, NodeFactory.createLiteral((String)"with ? mark"));
        query.setParam(1, NodeFactory.createLiteral((String)"with ? mark"));
        query.setParam(2, NodeFactory.createLiteral((String)"test"));
        Assert.assertEquals((Object)"SELECT * WHERE { \"with ? mark\" \"with ? mark\" \"test\" . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_positional_5() {
        String cmdText = "SELECT * WHERE { ? ? ?. }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setParam(0, NodeFactory.createURI((String)"http://example.org"));
        query.setParam(1, NodeFactory.createURI((String)"http://predicate"));
        query.setParam(2, NodeFactory.createLiteral((String)"test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\". }", (Object)query.toString());
    }

    @Test
    public void test_param_string_positional_6() {
        String cmdText = "SELECT * WHERE { ? ? ?; ?p ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setParam(0, NodeFactory.createURI((String)"http://example.org"));
        query.setParam(1, NodeFactory.createURI((String)"http://predicate"));
        query.setParam(2, NodeFactory.createLiteral((String)"test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\"; ?p ?o . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_positional_7() {
        String cmdText = "SELECT * WHERE { ? ? ?, ?o . }";
        ParameterizedSparqlString query = new ParameterizedSparqlString(cmdText);
        query.setParam(0, NodeFactory.createURI((String)"http://example.org"));
        query.setParam(1, NodeFactory.createURI((String)"http://predicate"));
        query.setParam(2, NodeFactory.createLiteral((String)"test"));
        Assert.assertEquals((Object)"SELECT * WHERE { <http://example.org> <http://predicate> \"test\", ?o . }", (Object)query.toString());
    }

    @Test
    public void test_param_string_positional_eligible_1() {
        String cmdText = "SELECT * WHERE { ?s ?p ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(cmdText);
        Iterator iter = pss.getEligiblePositionalParameters();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void test_param_string_positional_eligible_2() {
        String cmdText = "SELECT * WHERE { ? ? ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(cmdText);
        Iterator iter = pss.getEligiblePositionalParameters();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void test_param_string_positional_eligible_3() {
        String cmdText = "SELECT * WHERE { ?s ?p ?; ?p1 ?, ?. }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(cmdText);
        Iterator iter = pss.getEligiblePositionalParameters();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_01() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setIri("var2", "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_02() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setIri("var2", "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_03() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var2", "hello\" } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_04() {
        String str = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setIri("var2", "hello> . ?s ?p ?o");
        Query q = pss.asQuery();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_05() {
        String str = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ?var2 . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var2", "hello\" . ?s ?p ?o");
        Query q = pss.asQuery();
        Element el = q.getQueryPattern();
        if (el instanceof ElementTriplesBlock) {
            Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)q.getQueryPattern()).getPattern().size());
        } else if (el instanceof ElementGroup) {
            Assert.assertEquals((long)1L, (long)((ElementGroup)el).getElements().size());
            el = (Element)((ElementGroup)el).getElements().get(0);
            if (el instanceof ElementTriplesBlock) {
                Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)el).getPattern().size());
            }
        }
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_06() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?var' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "hello' . } ; DROP ALL ; INSERT DATA { <s> <p> \"goodbye");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_07() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"?var\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_08() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?var' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_09() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "\" . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_10() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "a");
        pss.setLiteral("var2", "b");
        String first = (String)pss.getVars().next();
        String second = first.equals("var") ? "var2" : "var";
        pss.setLiteral(first, "?" + second);
        pss.setLiteral(second, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_11() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \" ?var \" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_12() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"some text ?var other text\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_injection_13() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ' ?var ' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_injection_14() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> 'some text ?var other text' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_injection_15() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?var }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "a");
        pss.setLiteral("var2", "b");
        String first = (String)pss.getVars().next();
        String second = first.equals("var") ? "var2" : "var";
        pss.setLiteral(first, " ?" + second + " ");
        pss.setLiteral(second, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_non_injection_01() {
        String str = "SELECT * { \"subject\" ?var \"object\" . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("var", "predicate");
        pss.toString();
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_01() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ?v . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setIri(0, "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_02() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setIri(0, "hello> } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_positional_injection_03() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "hello\" } ; DROP ALL ; INSERT DATA { <s> <p> <goodbye>");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_04() {
        String str = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setIri(0, "hello> . ?s ?p ?o");
        Query q = pss.asQuery();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_positional_injection_05() {
        String str = "PREFIX : <http://example/>\nSELECT * WHERE { <s> <p> ? . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "hello\" . ?s ?p ?o");
        Query q = pss.asQuery();
        Element el = q.getQueryPattern();
        if (el instanceof ElementTriplesBlock) {
            Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)q.getQueryPattern()).getPattern().size());
        } else if (el instanceof ElementGroup) {
            Assert.assertEquals((long)1L, (long)((ElementGroup)el).getElements().size());
            el = (Element)((ElementGroup)el).getElements().get(0);
            if (el instanceof ElementTriplesBlock) {
                Assert.assertEquals((long)1L, (long)((ElementTriplesBlock)el).getPattern().size());
            }
        }
    }

    @Test
    public void test_param_string_positional_injection_06() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "hello' . } ; DROP ALL ; INSERT DATA { <s> <p> \"goodbye");
        Assert.assertFalse((boolean)pss.getEligiblePositionalParameters().hasNext());
    }

    @Test
    public void test_param_string_positional_injection_07() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"?\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        Assert.assertFalse((boolean)pss.getEligiblePositionalParameters().hasNext());
    }

    @Test
    public void test_param_string_positional_injection_08() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> '?' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        Assert.assertFalse((boolean)pss.getEligiblePositionalParameters().hasNext());
    }

    @Test
    public void test_param_string_positional_injection_09() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "\" . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_positional_injection_10() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "?");
        pss.setLiteral(1, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        Iterator params = pss.getEligiblePositionalParameters();
        Assert.assertTrue((boolean)params.hasNext());
        params.next();
        Assert.assertFalse((boolean)params.hasNext());
        UpdateRequest u = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)u.getOperations().size());
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_11() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \" ? \" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test(expected=ARQException.class)
    public void test_param_string_positional_injection_12() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> \"some text ? other text\" }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        UpdateRequest updates = pss.asUpdate();
        Assert.fail((String)"Attempt to do SPARQL injection should result in an exception");
    }

    @Test
    public void test_param_string_positional_injection_13() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ' ? ' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_positional_injection_14() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> 'some text ? other text' }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "' . } ; DROP ALL ; INSERT DATA { <s> <p> <o> }#");
        UpdateRequest updates = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)updates.getOperations().size());
    }

    @Test
    public void test_param_string_positional_injection_15() {
        String str = "PREFIX : <http://example/>\nINSERT DATA { <s> <p> ? }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, " ? ");
        pss.setLiteral(1, " . } ; DROP ALL ; INSERT DATA { <s> <p> ");
        Iterator params = pss.getEligiblePositionalParameters();
        Assert.assertTrue((boolean)params.hasNext());
        params.next();
        Assert.assertFalse((boolean)params.hasNext());
        UpdateRequest u = pss.asUpdate();
        Assert.assertEquals((long)1L, (long)u.getOperations().size());
    }

    @Test
    public void test_param_string_positional_non_injection_01() {
        String str = "SELECT * { \"subject\" ? \"object\" . }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral(0, "predicate");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_01() {
        String str = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("o", "has$sign");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_02() {
        String str = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("o", "has$1sign");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_03() {
        String str = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("o", "has$5sign");
        pss.toString();
    }

    @Test
    public void test_param_string_bug_04() {
        String str = "SELECT * WHERE { ?s ?p ?o }";
        ParameterizedSparqlString pss = new ParameterizedSparqlString(str);
        pss.setLiteral("o", "has $9 sign");
        pss.toString();
    }
}

