/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestOpVars
extends BaseTest {
    @Test
    public void opvars_01() {
        TestOpVars.visible("(bgp (?s :p ?o))", "s", "o");
    }

    @Test
    public void opvars_02() {
        TestOpVars.visible("(leftjoin (bgp (?s :p ?o)) (bgp (?s1 :p ?o1)) )", "s1", "o1", "s", "o");
    }

    @Test
    public void opvars_03() {
        TestOpVars.visible("(leftjoin (bgp (?s :p ?o)) (bgp (?s :p ?o)) )", "s", "o");
    }

    @Test
    public void opvars_04() {
        TestOpVars.visible("(project (?s) (bgp(?s :p ?o)))", "s");
    }

    @Test
    public void opvars_05() {
        TestOpVars.visible("(minus (bgp (?s :p ?o)) (bgp (?s1 :p ?o1)) )", "s", "o");
    }

    @Test
    public void opvars_06() {
        TestOpVars.visible("(join (project (?x) (bgp(?x :p ?z)))  (bgp(?s :p 1)) )", "x", "s");
    }

    @Test
    public void opvars_10() {
        TestOpVars.fixed("(bgp (?s :p ?o))", "s", "o");
    }

    @Test
    public void opvars_11() {
        TestOpVars.fixed("(leftjoin (bgp (?s :p ?o)) (bgp (?s1 :p ?o1)) )", "s", "o");
    }

    @Test
    public void opvars_12() {
        TestOpVars.fixed("(leftjoin (bgp (?s :p ?o)) (bgp (?s :p ?o)) )", "s", "o");
    }

    @Test
    public void opvars_13() {
        TestOpVars.fixed("(union (bgp (?s :p ?o1)) (bgp (?s :p ?o2)) )", "s");
    }

    @Test
    public void opvars_14() {
        TestOpVars.fixed("(minus (bgp (?s :p ?o)) (bgp (?s1 :p ?o1)) )", "s", "o");
    }

    @Test
    public void opvars_15() {
        TestOpVars.fixed("(join (project (?x) (bgp(?x :p ?z)))  (bgp(?s :p 1)) )", "x", "s");
    }

    private static void visible(String string, String ... vars) {
        Op op = SSE.parseOp((String)string);
        Set c = OpVars.visibleVars((Op)op);
        TestOpVars.check(vars, c);
    }

    private static void fixed(String string, String ... vars) {
        Op op = SSE.parseOp((String)string);
        Set c = OpVars.fixedVars((Op)op);
        TestOpVars.check(vars, c);
    }

    private static void check(String[] varsExpected, Collection<Var> varsFound) {
        Var[] vars = new Var[varsExpected.length];
        for (int i = 0; i < varsExpected.length; ++i) {
            Var v;
            vars[i] = v = Var.alloc((String)varsExpected[i]);
        }
        List<Var> varList = Arrays.asList(vars);
        HashSet<Var> varSet = new HashSet<Var>();
        varSet.addAll(varList);
        TestOpVars.assertEquals(varSet, varsFound);
    }
}

