/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.AlgebraQuad;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.writers.WriterOp;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.junit.Test;

public class TestTransformOpExt
extends BaseTest {
    @Test
    public void textOpExtQuads() {
        String x = StrUtils.strjoinNL((String[])new String[]{"(graph <g>", "    (join", "     (bgp (?s ?p ?o))", "      (graph <g2> (bgp (?s ?p ?o)))", "))"});
        String y = StrUtils.strjoinNL((String[])new String[]{"(join", "   (quadpattern (quad <g> ?s ?p ?o))", "   (quadpattern (quad <g2> ?s ?p ?o)))"});
        Op op = SSE.parseOp((String)x);
        OpGraph opg = (OpGraph)op;
        Object op1 = opg.getSubOp();
        op1 = new OpExtTest((Op)op1);
        op = new OpGraph(opg.getNode(), op1);
        Op op2 = AlgebraQuad.quadize((Op)op);
        TestTransformOpExt.assertTrue((boolean)(op2 instanceof OpExt));
        Op opSub = ((OpExt)op2).effectiveOp();
        Op expectedSub = SSE.parseOp((String)y);
        TestTransformOpExt.assertEquals((Object)expectedSub, (Object)opSub);
    }

    static class OpExtTest
    extends OpExt {
        private Op op;

        OpExtTest(Op op) {
            super("test");
            this.op = op;
        }

        public Op apply(Transform transform, OpVisitor before, OpVisitor after) {
            Op opx = Transformer.transformSkipService((Transform)transform, (Op)this.op, (OpVisitor)before, (OpVisitor)after);
            return new OpExtTest(opx);
        }

        public Op effectiveOp() {
            return this.op;
        }

        public QueryIterator eval(QueryIterator input, ExecutionContext execCxt) {
            return null;
        }

        public void outputArgs(IndentedWriter out, SerializationContext sCxt) {
            out.println();
            WriterOp.output((IndentedWriter)out, (Op)this.op, (SerializationContext)sCxt);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
            return other instanceof OpExtTest;
        }
    }
}

