/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.sse.SSE;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.junit.Assert;

public abstract class AbstractTestTransform
extends BaseTest {
    public void testOptimize(String input, String ... output) {
        Query q = QueryFactory.create((String)input);
        Op op = Algebra.compile((Query)q);
        AbstractTestTransform.check(op, StrUtils.strjoinNL((String[])output));
    }

    public void testQuery(String input, Transform transform, String ... output) {
        Query q = QueryFactory.create((String)input);
        Op op = Algebra.compile((Query)q);
        this.test(op, transform, output);
    }

    public void testOp(String input, Transform transform, String ... output) {
        Op op1 = SSE.parseOp((String)input);
        this.test(op1, transform, output);
    }

    public void test(Op op1, Transform transform, String ... output) {
        Op op2 = Transformer.transform((Transform)transform, (Op)op1);
        if (output == null) {
            Assert.assertEquals((Object)op1, (Object)op2);
            return;
        }
        Op op3 = SSE.parseOp((String)StrUtils.strjoinNL((String[])output));
        Assert.assertEquals((Object)op3, (Object)op2);
    }

    public static void check(String queryString, String opExpectedString) {
        queryString = "PREFIX : <http://example/>\n" + queryString;
        Query query = QueryFactory.create((String)queryString);
        Op opQuery = Algebra.compile((Query)query);
        Op op1 = Algebra.compile((Query)query);
        AbstractTestTransform.check(opQuery, opExpectedString);
        AbstractTestTransform.assertEquals((String)"Modification of input during optimization", (Object)op1, (Object)opQuery);
    }

    private static void check(Op opToOptimize, String opExpectedString) {
        Op opOptimize = Algebra.optimize((Op)opToOptimize);
        Op opExpected = SSE.parseOp((String)opExpectedString);
        AbstractTestTransform.assertEquals((Object)opExpected, (Object)opOptimize);
    }

    public static void check(Op opToOptimize, Transform additionalOptimizer, String opExpectedString) {
        Op opOptimize = Algebra.optimize((Op)opToOptimize);
        opOptimize = Transformer.transform((Transform)additionalOptimizer, (Op)opOptimize);
        Op opExpected = SSE.parseOp((String)opExpectedString);
        AbstractTestTransform.assertEquals((Object)opExpected, (Object)opOptimize);
    }

    public static void checkAlgebra(String algString, Transform additionalOptimizer, String opExpectedString) {
        Op algebra = SSE.parseOp((String)algString);
        Op algebra1 = SSE.parseOp((String)algString);
        Op optimized = Algebra.optimize((Op)algebra);
        if (additionalOptimizer != null) {
            optimized = Transformer.transform((Transform)additionalOptimizer, (Op)optimized);
        }
        Op opExpected = SSE.parseOp((String)(opExpectedString != null ? opExpectedString : algString));
        AbstractTestTransform.assertEquals((Object)opExpected, (Object)optimized);
        AbstractTestTransform.assertEquals((String)"Modification of input during optimization", (Object)algebra1, (Object)algebra);
    }

    public static void checkAlgebra(String algString, String opExpectedString) {
        AbstractTestTransform.checkAlgebra(algString, null, opExpectedString);
    }
}

