/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.optimize.AbstractTestTransform;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformDistinctToReduced;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformOrderByDistinctApplication;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.junit.Test;

public class TestOptDistinctReduced
extends AbstractTestTransform {
    Transform tDistinctToReduced = new TransformDistinctToReduced();
    Transform tOrderByDistinctApplication = new TransformOrderByDistinctApplication();

    @Test
    public void distinct_to_reduced_01() {
        String queryString = "SELECT DISTINCT * { ?s ?p ?o } ORDER BY ?p ?o";
        String opExpectedString = "(distinct\n  (order (?p ?o)\n    (bgp (triple ?s ?p ?o))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_02() {
        String queryString = "SELECT DISTINCT * { ?s ?p 123 } ORDER BY ?s ?p";
        String opExpectedString = "(reduced\n  (order (?s ?p)\n    (bgp (triple ?s ?p 123))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_03() {
        String queryString = "SELECT DISTINCT * { ?s ?p ?o } ORDER BY ?s ?p ?o";
        String opExpectedString = "(reduced\n  (order (?s ?p ?o)\n    (bgp (triple ?s ?p ?o))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_04() {
        String queryString = "SELECT DISTINCT ?p { ?s ?p ?o } ORDER BY ?p ?o";
        String opExpectedString = "(reduced\n  (project (?p)\n    (order (?p ?o)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_05() {
        String queryString = "SELECT DISTINCT ?p { ?s ?p ?o } ORDER BY ?o ?p";
        String opExpectedString = "(distinct\n  (project (?p)\n    (order (?o ?p)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_06() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optDistinctToReduced));
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ORDER BY ?p ?o";
        String opExpectedString = "(reduced\n  (project (?p ?o)\n    (order (?p ?o)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_07() {
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ORDER BY ?o ?p";
        String opExpectedString = "(reduced\n  (project (?p ?o)\n    (order (?o ?p)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_08() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optDistinctToReduced));
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ORDER BY ?o ?p ?s";
        String opExpectedString = "(reduced\n  (project (?p ?o)\n    (order (?o ?p ?s)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_09() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optDistinctToReduced));
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ORDER BY ?p ?o ?s";
        String opExpectedString = "(reduced\n  (project (?p ?o)\n    (order (?p ?o ?s)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_10() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optDistinctToReduced));
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ORDER BY ?s ?p ?o";
        String opExpectedString = "(distinct\n  (project (?p ?o)\n    (order (?s ?p ?o)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_11() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optDistinctToReduced));
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ORDER BY ?p ?s ?o";
        String opExpectedString = "(distinct\n  (project (?p ?o)\n    (order (?p ?s ?o)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_12() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optDistinctToReduced));
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ORDER BY ?s";
        String opExpectedString = "(distinct\n  (project (?p ?o)\n    (order (?s)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_to_reduced_13() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optDistinctToReduced));
        String queryString = "SELECT DISTINCT ?p ?o { ?s ?p ?o } ";
        String opExpectedString = "(distinct\n  (project (?p ?o)\n      (bgp (triple ?s ?p ?o))))";
        this.testQuery(queryString, this.tDistinctToReduced, opExpectedString);
    }

    @Test
    public void distinct_order_by_application_01() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optOrderByDistinctApplication));
        String queryString = "SELECT DISTINCT ?p { ?s ?p ?o } ORDER BY ?p";
        String opExpectedString = "(order (?p)\n  (distinct\n    (project (?p)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tOrderByDistinctApplication, opExpectedString);
    }

    @Test
    public void distinct_order_by_application_03() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optOrderByDistinctApplication));
        String queryString = "SELECT DISTINCT * { ?s ?p ?o } ORDER BY ?p";
        String opExpectedString = "  (distinct\n    (order (?p)\n      (bgp (triple ?s ?p ?o))))";
        this.testQuery(queryString, this.tOrderByDistinctApplication, opExpectedString);
    }

    @Test
    public void distinct_order_by_application_04() {
        String queryString = "SELECT DISTINCT ?p { ?s ?p ?o } ORDER BY LCASE(STR(?p))";
        String opExpectedString = "(order ((lcase (str (?p))))\n  (distinct\n    (project (?p)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tOrderByDistinctApplication, opExpectedString);
    }

    @Test
    public void distinct_order_by_application_05() {
        String queryString = "SELECT DISTINCT ?s ?p { ?s ?p ?o } ORDER BY LCASE(CONCAT(?s, ?p))";
        String opExpectedString = "(order ((lcase (concat ?s ?p)))\n  (distinct\n    (project (?s ?p)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tOrderByDistinctApplication, opExpectedString);
    }

    @Test
    public void distinct_order_by_application_06() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optOrderByDistinctApplication));
        String queryString = "SELECT DISTINCT ?p { ?s ?p ?o } ORDER BY LCASE(CONCAT(?s, ?p))";
        String opExpectedString = "  (distinct\n    (project (?p)\n      (order ((lcase (concat ?s ?p)))\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tOrderByDistinctApplication, opExpectedString);
    }

    @Test
    public void reduced_order_by_application_01() {
        TestOptDistinctReduced.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optOrderByDistinctApplication));
        String queryString = "SELECT REDUCED ?p { ?s ?p ?o } ORDER BY ?p";
        String opExpectedString = "(order (?p)\n  (reduced\n    (project (?p)\n      (bgp (triple ?s ?p ?o)))))";
        this.testQuery(queryString, this.tOrderByDistinctApplication, opExpectedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reduced_order_by_application_02() {
        try {
            ARQ.setFalse((Symbol)ARQ.optOrderByDistinctApplication);
            TestOptDistinctReduced.assertTrue((boolean)ARQ.isFalse((Symbol)ARQ.optOrderByDistinctApplication));
            String queryString = "SELECT REDUCED ?p { ?s ?p ?o } ORDER BY ?p";
            String opExpectedString = "(reduced\n  (project (?p)\n    (order (?p)\n      (bgp (triple ?s ?p ?o)))))";
            this.testOptimize(queryString, opExpectedString);
        }
        finally {
            ARQ.unset((Symbol)ARQ.optOrderByDistinctApplication);
        }
    }
}

