/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.optimize.AbstractTestTransform;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformExtendCombine;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.apache.jena.atlas.lib.StrUtils;
import org.junit.Test;

public class TestOptimizer
extends AbstractTestTransform {
    @Test
    public void slice_order_to_topn_01() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT * { ?s ?p ?o } ORDER BY ?p ?o LIMIT 42";
        String opExpectedString = "(top (42 ?p ?o)\n  (bgp (triple ?s ?p ?o)))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_02() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT * { ?s ?p ?o } ORDER BY ?p ?o LIMIT 4242";
        String opExpectedString = "(slice _ 4242\n  (order (?p ?o)\n    (bgp (triple ?s ?p ?o))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_03() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT * { ?s ?p ?o } ORDER BY ?p ?o OFFSET 4242 LIMIT 10";
        String opExpectedString = "(slice 4242 10\n  (order (?p ?o)\n    (bgp (triple ?s ?p ?o))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slice_order_to_topn_04() {
        try {
            ARQ.setFalse((Symbol)ARQ.optTopNSorting);
            TestOptimizer.assertTrue((boolean)ARQ.isFalse((Symbol)ARQ.optTopNSorting));
            String queryString = "SELECT * { ?s ?p ?o } ORDER BY ?p ?o LIMIT 42";
            String opExpectedString = "(slice _ 42\n  (order (?p ?o)\n    (bgp (triple ?s ?p ?o))))";
            TestOptimizer.check(queryString, opExpectedString);
        }
        finally {
            ARQ.unset((Symbol)ARQ.optTopNSorting);
        }
    }

    @Test
    public void slice_order_to_topn_05() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT DISTINCT * { ?s ?p ?o } ORDER BY ?p ?o LIMIT 42";
        String opExpectedString = "(top (42 ?p ?o)\n  (distinct\n     (bgp (triple ?s ?p ?o))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_06() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT DISTINCT * { ?s ?p ?o } ORDER BY ?p ?o OFFSET 24 LIMIT 42";
        String opExpectedString = "(slice 24 _\n  (top (66 ?p ?o)\n    (distinct\n       (bgp (triple ?s ?p ?o)))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_07() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT REDUCED * { ?s ?p ?o } ORDER BY ?p ?o LIMIT 42";
        String opExpectedString = "(top (42 ?p ?o)\n  (distinct\n     (bgp (triple ?s ?p ?o))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_08() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT DISTINCT * { ?s ?p ?o } ORDER BY ?p ?o LIMIT 4242";
        String opExpectedString = "(slice _ 4242\n  (distinct\n    (order (?p ?o)\n      (bgp (triple ?s ?p ?o)))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_09() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT REDUCED * { ?s ?p ?o } ORDER BY ?p ?o LIMIT 4242";
        String opExpectedString = "(slice _ 4242\n  (reduced\n    (order (?p ?o)\n      (bgp (triple ?s ?p ?o)))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_10() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT * { ?s ?p ?o } ORDER BY ?p ?o OFFSET 1 LIMIT 5";
        String opExpectedString = "(slice 1 _\n  (top (6 ?p ?o)\n    (bgp (triple ?s ?p ?o))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_11() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT ?s { ?s ?p ?o } ORDER BY ?p ?o OFFSET 1 LIMIT 5";
        String opExpectedString = "(slice 1 _\n  (project (?s)\n    (top (6 ?p ?o)\n      (bgp (triple ?s ?p ?o)))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void slice_order_to_topn_12() {
        TestOptimizer.assertTrue((boolean)ARQ.isTrueOrUndef((Symbol)ARQ.optTopNSorting));
        String queryString = "SELECT ?s { ?s ?p ?o } ORDER BY ?p ?o LIMIT 42";
        String opExpectedString = "(project (?s)\n  (top (42 ?p ?o)\n    (bgp (triple ?s ?p ?o))))";
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void subQueryProject_01() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "WHERE {", "    ?test ?p1 ?X.", "    { SELECT ?s1 ?test { ?test ?p2 ?o2 } }", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(sequence", "  (bgp (triple ?test ?p1 ?X))", "  (project (?s1 ?test)", "    (bgp (triple ?test ?/p2 ?/o2))))"});
        TestOptimizer.check(qs, ops);
    }

    @Test
    public void subQueryProject_02() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "WHERE {", "    ?test ?p1 ?X.", "    { SELECT ?s1 { ?test ?p2 ?o2 } }", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(sequence", "  (bgp (triple ?test ?p1 ?X))", "  (project (?s1)", "    (bgp (triple ?/test ?/p2 ?/o2))))"});
        TestOptimizer.check(qs, ops);
    }

    @Test
    public void optimize_01() {
        String queryString = "SELECT * { { ?s ?p ?x } UNION { ?s1 ?p1 ?x } FILTER(?x = <urn:x1> || ?x = <urn:x2>) }";
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(disjunction", "    (assign ((?x <urn:x1>))", "      (union", "        (bgp (triple ?s ?p <urn:x1>))", "        (bgp (triple ?s1 ?p1 <urn:x1>))))", "    (assign ((?x <urn:x2>))", "      (union", "        (bgp (triple ?s ?p <urn:x2>))", "        (bgp (triple ?s1 ?p1 <urn:x2>)))))"});
        TestOptimizer.check(queryString, opExpectedString);
    }

    @Test
    public void combine_extend_01() {
        OpExtend extend = OpExtend.create((Op)OpTable.unit(), (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(1L)));
        extend = OpExtend.create((Op)extend, (VarExprList)new VarExprList(Var.alloc((String)"y"), (Expr)new NodeValueInteger(2L)));
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(extend ((?x 1) (?y 2))", "  (table unit))"});
        TestOptimizer.check((Op)extend, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_extend_02() {
        OpExtend extend = OpExtend.create((Op)OpTable.unit(), (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(1L)));
        extend = OpExtend.create((Op)extend, (VarExprList)new VarExprList(Var.alloc((String)"y"), (Expr)new ExprVar("x")));
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(extend ((?x 1) (?y ?x))", "  (table unit))"});
        TestOptimizer.check((Op)extend, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_extend_03() {
        OpExtend extend = OpExtend.create((Op)OpTable.unit(), (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(1L)));
        extend = OpExtend.create((Op)extend, (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(2L)));
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(extend ((?x 2))", "  (extend ((?x 1))", "    (table unit)))"});
        TestOptimizer.check((Op)extend, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_extend_04() {
        String opString = StrUtils.strjoinNL((String[])new String[]{"(extend ((?x 2))", "  (extend ((?y 3))", "    (distinct", "      (extend ((?a 'A') (?b 'B'))", "        (extend ((?c 'C'))", "          (table unit)", "        )))))"});
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(extend ((?y 3) (?x 2))", "  (distinct", "    (extend ((?c 'C') (?a 'A') (?b 'B'))", "      (table unit))))"});
        Op op = SSE.parseOp((String)opString);
        TestOptimizer.check(op, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_extend_05() {
        String x = "(project (?x) (extend ((?bar 2)) (extend ((?foo 1)) (table unit))))";
        String y = "(project (?x) (extend ((?foo 1) (?bar 2)) (table unit)))";
        AbstractTestTransform.checkAlgebra(x, (Transform)new TransformExtendCombine(), y);
    }

    @Test
    public void combine_assign_01() {
        OpAssign assign = OpAssign.create((Op)OpTable.unit(), (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(1L)));
        assign = OpAssign.create((Op)assign, (VarExprList)new VarExprList(Var.alloc((String)"y"), (Expr)new NodeValueInteger(2L)));
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(assign ((?x 1) (?y 2))", "  (table unit))"});
        TestOptimizer.check((Op)assign, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_assign_02() {
        OpAssign assign = OpAssign.create((Op)OpTable.unit(), (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(1L)));
        assign = OpAssign.create((Op)assign, (VarExprList)new VarExprList(Var.alloc((String)"y"), (Expr)new ExprVar("x")));
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(assign ((?x 1) (?y ?x))", "  (table unit))"});
        TestOptimizer.check((Op)assign, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_assign_03() {
        OpAssign assign = OpAssign.create((Op)OpTable.unit(), (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(1L)));
        assign = OpAssign.create((Op)assign, (VarExprList)new VarExprList(Var.alloc((String)"x"), (Expr)new NodeValueInteger(2L)));
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(assign ((?x 2))", "  (assign ((?x 1))", "    (table unit)))"});
        TestOptimizer.check((Op)assign, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_assign_04() {
        String opString = StrUtils.strjoinNL((String[])new String[]{"(assign ((?x 2))", "  (assign ((?y 3))", "    (distinct", "      (assign ((?a 'A') (?b 'B'))", "        (assign ((?c 'C'))", "          (table unit)", "        )))))"});
        String opExpectedString = StrUtils.strjoinNL((String[])new String[]{"(assign ((?y 3) (?x 2))", "  (distinct", "    (assign ((?c 'C') (?a 'A') (?b 'B'))", "      (table unit))))"});
        Op op = SSE.parseOp((String)opString);
        TestOptimizer.check(op, (Transform)new TransformExtendCombine(), opExpectedString);
    }

    @Test
    public void combine_assign_05() {
        String x = "(project (?x) (assign ((?bar 2)) (assign ((?foo 1)) (table unit))))";
        String y = "(project (?x) (assign ((?foo 1) (?bar 2)) (table unit)))";
        AbstractTestTransform.checkAlgebra(x, (Transform)new TransformExtendCombine(), y);
    }
}

