/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.optimize.AbstractTestTransform;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformReorder;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderFixed;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.junit.Test;

public class TestReorderBGP
extends AbstractTestTransform {
    private static Transform t_reorder = new TransformReorder((ReorderTransformation)new ReorderFixed());
    private static String expected3 = "(bgp  (?s :p 123)  (?s rdf:type :T) (?s :p ?o) )";

    @Test
    public void reorderbgp_1_1() {
        this.testOp("(bgp (?s :p ?o))", t_reorder, "(bgp (?s :p ?o))");
    }

    @Test
    public void reorderbgp_1_2() {
        this.testOp("(bgp (?s ?p ?o))", t_reorder, "(bgp (?s ?p ?o))");
    }

    @Test
    public void reorderbgp_2_1() {
        this.testOp("(bgp (?s :p ?o) (?s :p 123) )", t_reorder, "(bgp  (?s :p 123) (?s :p ?o))");
    }

    @Test
    public void reorderbgp_2_2() {
        this.testOp("(bgp (?s :p 123) (?s :p ?o) )", t_reorder, "(bgp  (?s :p 123) (?s :p ?o))");
    }

    @Test
    public void reorderbgp_2_3() {
        this.testOp("(bgp (?s :p 123) (?s rdf:type :T) )", t_reorder, "(bgp  (?s :p 123) (?s rdf:type :T))");
    }

    @Test
    public void reorderbgp_2_4() {
        this.testOp("(bgp (?s rdf:type :T) (?s :p 123) )", t_reorder, "(bgp  (?s :p 123) (?s rdf:type :T))");
    }

    @Test
    public void reorderbgp_3_1() {
        this.testOp("(bgp (?s rdf:type :T) (?s :p ?o) (?s :p 123) )", t_reorder, expected3);
    }

    @Test
    public void reorderbgp_3_2() {
        this.testOp("(bgp (?s :p ?o) (?s :p 123) (?s rdf:type :T) )", t_reorder, expected3);
    }

    @Test
    public void reorderbgp_3_3() {
        this.testOp("(bgp (?s :p 123) (?s rdf:type :T) (?s :p ?o) )", t_reorder, expected3);
    }

    @Test
    public void reorderbgp_3_4() {
        this.testOp("(bgp (?s rdf:type :T) (?s :p 123)  (?s :p ?o) )", t_reorder, expected3);
    }

    @Test
    public void reorderbgp_3_5() {
        this.testOp("(bgp (?s :p 123)  (?s :p ?o) (?s rdf:type :T))", t_reorder, expected3);
    }

    @Test
    public void reorderbgp_3_6() {
        this.testOp("(bgp (?s :p ?o) (?s rdf:type :T) (?s :p 123)  )", t_reorder, expected3);
    }
}

