/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.optimize.AbstractTestTransform;
import com.hp.hpl.jena.sparql.algebra.optimize.TestOptimizer;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformExpandOneOf;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterDisjunction;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterEquality;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterImplicitJoin;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterInequality;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformImplicitLeftJoin;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformJoinStrategy;
import org.apache.jena.atlas.lib.StrUtils;
import org.junit.Test;

public class TestTransformFilters
extends AbstractTestTransform {
    private Transform t_equality = new TransformFilterEquality();
    private Transform t_inequality = new TransformFilterInequality();
    private Transform t_disjunction = new TransformFilterDisjunction();
    private Transform t_expandOneOf = new TransformExpandOneOf();
    private Transform t_implicitJoin = new TransformFilterImplicitJoin();
    private Transform t_implicitLeftJoin = new TransformImplicitLeftJoin();

    @Test
    public void equality01() {
        this.testOp("(filter (= ?x <x>) (bgp ( ?s ?p ?x)) )", this.t_equality, "(assign ((?x <x>)) (bgp ( ?s ?p <x>)) )");
    }

    @Test
    public void equality02() {
        if (JenaRuntime.isRDF11) {
            this.testOp("(filter (= ?x 'x') (bgp ( ?s ?p ?x)) )", this.t_equality, "(assign ((?x 'x')) (bgp ( ?s ?p 'x')) )");
        } else {
            this.testOp("(filter (= ?x 'x') (bgp ( ?s ?p ?x)) )", this.t_equality, null);
        }
    }

    @Test
    public void equality02a() {
        if (JenaRuntime.isRDF11) {
            this.testOp("(filter (= ?x 'x'^^xsd:string) (bgp ( ?s ?p ?x)) )", this.t_equality, "(assign ((?x 'x')) (bgp ( ?s ?p 'x')) )");
        } else {
            this.testOp("(filter (= ?x 'x'^^xsd:string) (bgp ( ?s ?p ?x)) )", this.t_equality, null);
        }
    }

    @Test
    public void equality03() {
        this.testOp("(filter (= ?x 123) (bgp ( ?s ?p ?x)) )", this.t_equality, null);
    }

    @Test
    public void equality04() {
        this.testOp("(filter (= ?UNUSED <x>) (bgp ( ?s ?p ?x)) )", this.t_equality, "(table empty)");
    }

    @Test
    public void equality05() {
        this.testOp("(filter (= ?x2 <x>) (conditional (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))", this.t_equality, "(filter (= ?x2 <x>) (conditional (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))");
    }

    @Test
    public void equality06() {
        this.testOp("(filter (= ?x <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x))))", this.t_equality, "(assign((?x <x>)) (conditional (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality07() {
        this.testOp("(filter (= ?x <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x <x>)) (conditional (bgp ( ?s ?p <x>))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality08() {
        this.testOp("(filter (= ?x1 <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(filter (= ?x1 <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality09() {
        this.testOp("(filter (= ?x2 <x>) (leftjoin (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))", this.t_equality, "(filter (= ?x2 <x>) (leftjoin (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))");
    }

    @Test
    public void equality10() {
        this.testOp("(filter (= ?x <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x))))", this.t_equality, "(assign((?x <x>)) (leftjoin (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality11() {
        this.testOp("(filter (= ?x <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x <x>)) (leftjoin (bgp ( ?s ?p <x>))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality12() {
        this.testOp("(filter (= ?x1 <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(filter (= ?x1 <x>) (leftjoin (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))");
    }

    @Test
    public void equality13() {
        this.testOp("(filter (= ?x1 <x>) (join (bgp ( ?s ?p ?x1))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x1 <x>))  (join (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality14() {
        this.testOp("(filter (= ?x1 <x>) (union (bgp ( ?s ?p ?x1))  (bgp ( ?s ?p ?x1))))", this.t_equality, "(assign((?x1 <x>))  (union (bgp ( ?s ?p <x>))  (bgp ( ?s ?p <x>))))");
    }

    @Test
    public void equality15() {
        this.testOp("(filter (= ?x1 <x>) (leftjoin (leftjoin (table unit) (bgp ( ?s ?p ?x1)) ) (bgp ( ?s ?p ?x1)) ))", this.t_equality, "(filter (= ?x1 <x>)", "   (leftjoin", "     (leftjoin", "       (table unit)", "       (assign ((?x1 <x>)) (bgp (triple ?s ?p <x>)))", "     )", "     (assign ((?x1 <x>)) (bgp (triple ?s ?p <x>)))", "   ))");
    }

    @Test
    public void equality16() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?test <http://localhost/t2>)", "  (leftjoin", "    (bgp (triple ?test ?p1 ?o1))", "      (project (?s1)", "       (bgp (triple ?s1 ?p2 ?o2)))))"});
        this.testOp(qs, this.t_equality, "(assign ((?test <http://localhost/t2>))", "  (leftjoin", "    (bgp (triple <http://localhost/t2> ?p1 ?o1))", "    (project (?s1)", "      (bgp (triple ?s1 ?p2 ?o2)))))");
    }

    @Test
    public void equality17() {
        this.testOp("(filter ((= ?x <http://constant1>) (= ?x <http://constant2>)) (join (bgp (?x <http://p1> ?o1)) (bgp (?x <http://p2> ?o2))))", this.t_equality, null);
    }

    @Test
    public void optionalEqualitySubQuery_01() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "WHERE {", "    ?test ?p1 ?X.", "    FILTER ( ?test = <http://localhost/t1> )", "    { SELECT ?s1 ?test { ?test ?p2 ?o2 } }", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(sequence", "   (assign ((?test <http://localhost/t1>))", "     (bgp (triple <http://localhost/t1> ?p1 ?X)))", "   (project (?s1 ?test)", "     (bgp (triple ?test ?/p2 ?/o2))))"});
        TestOptimizer.check(qs, ops);
    }

    @Test
    public void optionalEqualitySubQuery_02() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"SELECT *", "WHERE {", "    ?test ?p1 ?X.", "    FILTER ( ?test = <http://localhost/t1> )", "    { SELECT ?s1 { ?test ?p2 ?o2 } }", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(sequence", "  (assign ((?test <http://localhost/t1>))", "     (bgp (triple <http://localhost/t1> ?p1 ?X)))", "  (project (?s1)", "     (bgp (triple ?/test ?/p2 ?/o2))) )"});
        TestOptimizer.check(qs, ops);
    }

    @Test
    public void optionalEquality_01() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/> SELECT * {", "    OPTIONAL { ?x :q ?o }", "    FILTER(?x = :x)", "    ?x :p ?o2", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(sequence", "   (conditional", "      (table unit)", "      (bgp (triple ?x <http://example/q> ?o)))", "    (assign ((?x <http://example/x>))", "      (bgp (triple <http://example/x> <http://example/p> ?o2)))", ")"});
        TestOptimizer.check(qs, ops);
    }

    @Test
    public void optionalEqualityScope_01() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/> SELECT * {", "    OPTIONAL { ?x :q ?o }", "    FILTER(?x = :x)", "    ?x :p ?o2", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(assign ((?x <http://example/x>))", "   (sequence", "       (conditional", "         (table unit)", "         (bgp (triple <http://example/x> <http://example/q> ?o)))", "       (bgp (triple <http://example/x> <http://example/p> ?o2))))"});
        String ops2 = StrUtils.strjoinNL((String[])new String[]{"(sequence", "  (conditional", "    (table unit)", "    (bgp (triple ?x <http://example/q> ?o)) )", "  (assign ((?x <http://example/x>))", "    (bgp (triple <http://example/x> <http://example/p> ?o2)))", "  )"});
        TestOptimizer.check(qs, ops2);
    }

    @Test
    public void optionalEqualityScope_02() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/> SELECT * {", "    ?x :p ?o2", "    OPTIONAL { ?x :q ?o }", "    FILTER(?x = :x)", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(conditional", "  (assign ((?x <http://example/x>))", "     (bgp (triple <http://example/x> <http://example/p> ?o2)))", "  (bgp (triple ?x <http://example/q> ?o))", "  )"});
        TestOptimizer.check(qs, ops);
    }

    @Test
    public void optionalEqualityScope_03() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/> SELECT * {", "    ?z :p ?o2", "    OPTIONAL { ?x :q ?o }", "    FILTER(?x = :x)", "}"});
        String ops = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x <http://example/x>)", "   (conditional", "     (bgp (triple ?z <http://example/p> ?o2))", "     (bgp (triple ?x <http://example/q> ?o))", "))"});
        TestOptimizer.check(qs, ops);
    }

    @Test
    public void test_OptEqualityScope_04() {
        String qs = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/> SELECT * {", "    OPTIONAL { ?x :q ?o }", "    FILTER(?x = :x)", "}"});
        String ops1 = StrUtils.strjoinNL((String[])new String[]{"(filter (= ?x <http://example/x>)", "    (conditional", "      (table unit)", "      (assign ((?x <http://example/x>))", "        (bgp (triple <http://example/x> <http://example/q> ?o)))))"});
        TestOptimizer.check(qs, ops1);
    }

    @Test
    public void disjunction01() {
        this.testOp("(filter (|| (= ?x <x>) (= ?x <y>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(disjunction ", "(assign ((?x <x>)) (bgp ( ?s ?p <x>)))", "(assign ((?x <y>)) (bgp ( ?s ?p <y>)))", ")");
    }

    @Test
    public void disjunction02() {
        this.testOp("(filter (|| (= ?x <x>) (!= ?x <y>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(disjunction ", "(assign ((?x <x>)) (bgp ( ?s ?p <x>)))", "(filter (!= ?x <y>) (bgp ( ?s ?p ?x)))", ")");
    }

    @Test
    public void disjunction03() {
        this.testOp("(filter (|| (!= ?x <x>) (= ?x <y>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(disjunction ", "(assign ((?x <y>)) (bgp ( ?s ?p <y>)))", "(filter (!= ?x <x>) (bgp ( ?s ?p ?x)))", ")");
    }

    @Test
    public void disjunction04() {
        this.testOp("(filter (|| (!= ?x <y>) (!= ?x <x>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, null);
    }

    @Test
    public void disjunction05() {
        this.testOp("(filter (exprlist (|| (= ?x <y>) (!= ?x <x>)))    (bgp ( ?s ?p ?x)) )", this.t_disjunction, "  (disjunction", "    (assign ((?x <y>)) (bgp ( ?s ?p <y>)))", "    (filter (!= ?x <x>) (bgp ( ?s ?p ?x)))", ")");
    }

    @Test
    public void disjunction06() {
        this.testOp("(filter (exprlist (lang ?x) (|| (= ?x <y>) (!= ?x <x>)))    (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(filter (lang ?x)", "  (disjunction", "    (assign ((?x <y>)) (bgp ( ?s ?p <y>)))", "    (filter (!= ?x <x>) (bgp ( ?s ?p ?x)))", "))");
    }

    @Test
    public void disjunction07() {
        this.testOp("(filter (exprlist (|| (= ?x <y>) (!= ?x <x>)) (lang ?x) )    (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(filter (lang ?x)", "  (disjunction", "    (assign ((?x <y>)) (bgp ( ?s ?p <y>)))", "    (filter (!= ?x <x>) (bgp ( ?s ?p ?x)))", "))");
    }

    @Test
    public void oneOf1() {
        this.testOp("(filter (in ?x <x> 2 3) (bgp (?s ?p ?x)))", this.t_expandOneOf, "(filter (|| ( || (= ?x <x>) (= ?x 2)) (= ?x 3)) (bgp (?s ?p ?x)))");
    }

    @Test
    public void oneOf2() {
        this.testOp("(filter (exprlist (= ?x 99) (in ?x <x> 2 3)) (bgp (?s ?p ?x)))", this.t_expandOneOf, "(filter (exprlist (= ?x 99) (|| ( || (= ?x <x>) (= ?x 2)) (= ?x 3))) (bgp (?s ?p ?x)))");
    }

    @Test
    public void oneOf3() {
        this.testOp("(filter (notin ?x <x> 2 3) (bgp (?s ?p ?x)))", this.t_expandOneOf, "(filter (exprlist (!= ?x <x>) (!= ?x 2) (!= ?x 3)) (bgp (?s ?p ?x)))");
    }

    @Test
    public void oneOf4() {
        this.testOp("(filter true (distinct (filter (in ?x 1 2) (bgp (?s ?p ?x)) )))", this.t_expandOneOf, "(filter true (distinct (filter (|| (= ?x 1) (= ?x 2) ) (bgp (triple ?s ?p ?x)) )))");
    }

    @Test
    public void oneOf5() {
        this.testOp("(filter true (distinct (filter (notin ?x 1 2) (bgp (?s ?p ?x)) )))", this.t_expandOneOf, "(filter true (distinct (filter (exprlist (!= ?x 1) (!= ?x 2)) (bgp (triple ?s ?p ?x)) )))");
    }

    @Test
    public void implicitJoin01() {
        this.testOp("(filter (= ?x ?y) (bgp (?x ?p ?o)(?y ?p1 ?o1)))", this.t_implicitJoin, "(assign ((?x ?y)) (bgp (?y ?p ?o)(?y ?p1 ?o1)))");
    }

    @Test
    public void implicitJoin02() {
        this.testOp("(filter (= ?x ?y) (bgp (?x ?p ?o)))", this.t_implicitJoin, "(table empty)");
    }

    @Test
    public void implicitJoin03() {
        this.testOp("(filter (= ?x ?y) (bgp (?x ?p ?o)(?a ?b ?y)))", this.t_implicitJoin, "(assign ((?x ?y)) (bgp (?y ?p ?o)(?a ?b ?y)))");
    }

    @Test
    public void implicitJoin04() {
        this.testOp("(filter (= ?x ?y) (bgp (?a ?b ?x)(?c ?d ?y)))", this.t_implicitJoin, "(filter (= ?x ?y) (bgp (?a ?b ?x)(?c ?d ?y)))");
    }

    @Test
    public void implicitJoin05() {
        this.testOp("(filter (sameTerm ?x ?y) (bgp (?a ?b ?x)(?c ?d ?y)))", this.t_implicitJoin, "(assign ((?x ?y)) (bgp (?a ?b ?y)(?c ?d ?y)))");
    }

    @Test
    public void implicitJoin06() {
        this.testOp("(filter (= ?x ?x) (bgp (?x ?p ?o)(?y ?p1 ?o1)))", this.t_implicitJoin, null);
    }

    @Test
    public void implicitJoin07() {
        this.testOp("(filter ((= ?x ?y) (= ?x ?z)) (bgp (?x ?p ?o)(?y ?p1 ?z)))", this.t_implicitJoin, null);
    }

    @Test
    public void implicitJoin08() {
        this.testOp("(filter (= ?x ?y) (join (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1))))", this.t_implicitJoin, "(assign ((?x ?y)) (join (bgp (?y ?p ?o)) (bgp (?y ?p1 ?o1))))");
        this.testOp("(filter (= ?y ?x) (join (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1))))", this.t_implicitJoin, "(assign ((?y ?x)) (join (bgp (?x ?p ?o)) (bgp (?x ?p1 ?o1))))");
    }

    @Test
    public void implicitJoin09() {
        this.testOp("(filter (= ?x ?y) (assign ((?x <http://constant>)) (bgp (?y ?p ?o))))", this.t_implicitJoin, null);
    }

    @Test
    public void implicitJoin10() {
        this.testOp("(filter (= ?x ?y) (leftjoin (leftjoin (bgp (?s <http://pred> ?o)) (bgp (?x ?p ?o))) (bgp (?y ?p1 ?o1))))", this.t_implicitJoin, null);
    }

    @Test
    public void implictJoin11() {
        this.testOp("(filter (= ?prebound ?y) (extend ((?y (ex:someFunction ?x))) (table unit)))", this.t_implicitJoin, "(table empty)");
    }

    @Test
    public void implicitJoin12() {
        this.testOp("(filter (= ?a ?b) (union (bgp (triple ?a :p :o1)) (bgp (triple ?b :p ?a))))", this.t_implicitJoin, "(assign ((?a ?b)) (bgp (triple ?b :p ?b)))");
    }

    @Test
    public void implicitJoin13() {
        this.testOp("(filter (= ?a ?b) (union (bgp (triple ?b :p ?a)) (bgp (triple ?a :p :o1))))", this.t_implicitJoin, "(assign ((?a ?b)) (bgp (triple ?b :p ?b)))");
    }

    @Test
    public void implicitJoin14() {
        this.testOp("(filter (= ?a ?b) (union (bgp (triple ?b :p :o1)) (bgp (triple ?a :p :o2))))", this.t_implicitJoin, "(table empty)");
    }

    @Test
    public void implicitJoin15() {
        this.testOp("(filter ((= ?a ?b) (= ?a ?p)) (union (bgp (triple ?a ?p :o1)) (bgp (triple ?b ?p ?a))))", this.t_implicitJoin, null);
    }

    @Test
    public void implicitJoin16() {
        this.testOp("(filter (= ?a ?b) (union (bgp (triple ?a :p ?b)) (bgp (triple ?b :p ?a))))", this.t_implicitJoin, "(assign ((?a ?b)) (union (bgp (triple ?b :p ?b)) (bgp (triple ?b :p ?b))))");
    }

    @Test
    public void implicitJoin17() {
        this.testOp("(union (bgp (triple ?a :p :o1)) (filter (= ?a ?b) (bgp (triple ?b :p ?a))))", this.t_implicitJoin, "(union (bgp (triple ?a :p :o1)) (assign ((?a ?b)) (bgp (triple ?b :p ?b))))");
    }

    @Test
    public void implicitLeftJoin01() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))))");
    }

    @Test
    public void implicitLeftJoin02() {
        this.testOp("(leftjoin (bgp (?y ?p ?o)) (bgp (?x ?p1 ?o1)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?y ?p ?o)) (assign ((?x ?y)) (bgp (?y ?p1 ?o1))))");
        this.testOp("(leftjoin (bgp (?y ?p ?o)) (bgp (?x ?p1 ?o1)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?y ?p ?o)) (assign ((?x ?y)) (bgp (?y ?p1 ?o1))))");
    }

    @Test
    public void implicitLeftJoin03() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?x <http://type> ?type)(?y ?p1 ?o1)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x <http://type> ?type)(?x ?p1 ?o1))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?x <http://type> ?type)(?y ?p1 ?o1)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x <http://type> ?type)(?x ?p1 ?o1))))");
    }

    @Test
    public void implicitLeftJoin04() {
        this.testOp("(leftjoin (bgp (?y ?p ?o)) (bgp (?x <http://type> ?type)(?y ?p1 ?o1)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?y ?p ?o)) (assign ((?x ?y)) (bgp (?y <http://type> ?type)(?y ?p1 ?o1))))");
        this.testOp("(leftjoin (bgp (?y ?p ?o)) (bgp (?x <http://type> ?type)(?y ?p1 ?o1)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?y ?p ?o)) (assign ((?x ?y)) (bgp (?y <http://type> ?type)(?y ?p1 ?o1))))");
    }

    @Test
    public void implicitLeftJoin05() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (bgp (?y ?p1 ?o1)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (bgp (?y ?p1 ?o1)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))))");
    }

    @Test
    public void implicitLeftJoin06() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (bgp (?x ?p1 ?o1)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (assign ((?x ?y)) (bgp (?y ?p1 ?o1))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (bgp (?x ?p1 ?o1)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (assign ((?x ?y)) (bgp (?y ?p1 ?o1))))");
    }

    @Test
    public void implicitLeftJoin07() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (bgp (?x <http://type> ?type)(?y ?p1 ?o1)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (assign ((?x ?y)) (bgp (?y <http://type> ?type)(?y ?p1 ?o1))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (bgp (?x <http://type> ?type)(?y ?p1 ?o1)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (assign ((?y ?x)) (bgp (?x <http://type> ?type)(?x ?p1 ?o1))))");
    }

    @Test
    public void implicitLeftJoin08() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (bgp (?a ?b ?c)) ((= ?x ?y)))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoin09() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1)) (&& (= ?x ?y) (> ?o1 ?o2)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))) (> ?o1 ?o2))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1)) (&& (> ?o1 ?o2) (= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))) (> ?o1 ?o2))");
    }

    @Test
    public void implicitLeftJoin10() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1)) (|| (= ?x ?y) (> ?o1 ?o2)))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoin11() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (leftjoin (bgp (?y ?p1 ?o1)) (bgp (?x ?p3 ?y))) (= ?x ?y))", this.t_implicitLeftJoin, null);
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (leftjoin (bgp (?y ?p1 ?o1)) (bgp (?x ?p3 ?y))) (= ?y ?x))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoin12() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?x ?y) (= ?x ?z)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?y ?x) (= ?x ?z)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?x ?y) (= ?z ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x))))");
    }

    @Test
    public void implicitLeftJoin13() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?x ?y) (= ?x ?z) (= ?y ?z)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?z)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x)))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?z ?y) (= ?x ?z) (= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?z ?x) (?y ?x)) (assign ((?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x)))))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((= ?z ?y) (= ?z ?x) (= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?z ?x) (?y ?x)) (assign ((?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x)))))");
    }

    @Test
    public void implicitLeftJoin14() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((&& (= ?x ?y) (= ?x ?z))))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x))))");
    }

    @Test
    public void implicitLeftJoin15() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((&& (&& (= ?x ?y) (> ?o1 10)) (= ?x ?z))))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x))) (> ?o1 10))");
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((&& (&& (> ?o1 10) (= ?x ?y)) (= ?x ?z))))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x))) (> ?o1 10))");
    }

    @Test
    public void implicitLeftJoin16() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((&& (&& (< ?o1 20) (&& (= ?x ?y) (> ?o1 10))) (= ?x ?z))))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x))) ((< ?o1 20) (> ?o1 10)))");
    }

    @Test
    public void implicitLeftJoin17() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((&& (&& (= ?x ?y) (> ?o1 10)) (< ?o1 20))))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?z))) ((> ?o1 10) (< ?o1 20)))");
    }

    @Test
    public void implicitLeftJoin18() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (bgp (?y ?p1 ?o1) (?y ?p2 ?z)) ((&& (&& (= ?x ?y) (= ?y ?z)) (= ?x ?z))))", this.t_implicitLeftJoin, "(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x) (?z ?x)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1) (?x ?p2 ?x)))))");
    }

    @Test
    public void implicitLeftJoin19() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (table unit) ((= ?x ?y)))", this.t_implicitLeftJoin, null);
        this.testOp("(leftjoin (bgp (?x ?p ?o)(?x <http://pred> ?y)) (table unit) ((= ?y ?x)))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoin20() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (table unit) ((= ?x ?y)))", this.t_implicitLeftJoin, null);
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (table unit) ((= ?y ?x)))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoin21() {
        this.testOp("(leftjoin (bgp (?y ?p ?o)) (table unit) ((= ?x ?y)))", this.t_implicitLeftJoin, null);
        this.testOp("(leftjoin (bgp (?y ?p ?o)) (table unit) ((= ?y ?x)))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoin22() {
        this.testOp("(leftjoin (bgp (?s ?p ?o)) (table unit) ((= ?x ?y)))", this.t_implicitLeftJoin, null);
        this.testOp("(leftjoin (bgp (?s ?p ?o)) (table unit) ((= ?y ?x)))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoin23() {
        this.testOp("(leftjoin (table unit) (bgp (?x ?p ?o)(?x <http://pred> ?y)) ((= ?x ?y)))", this.t_implicitLeftJoin, "(leftjoin (table unit) (assign ((?x ?y)) (bgp (?y ?p ?o)(?y <http://pred> ?y))))");
        this.testOp("(leftjoin (table unit) (bgp (?x ?p ?o)(?x <http://pred> ?y)) ((= ?y ?x)))", this.t_implicitLeftJoin, "(leftjoin (table unit) (assign ((?y ?x)) (bgp (?x ?p ?o)(?x <http://pred> ?x))))");
    }

    @Test
    public void implicitLeftJoin24() {
        this.testOp("(leftjoin (bgp (triple ?a <http://type> ?type)) (union (bgp (triple ?a :p :o1)) (bgp (triple ?b :p ?a))) ((= ?a ?b)))", this.t_implicitLeftJoin, null);
    }

    @Test
    public void implicitLeftJoinConditional01() {
        this.testOp("(leftjoin (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))))", (Transform)new TransformJoinStrategy(), "(conditional (bgp (?x ?p ?o)) (assign ((?y ?x)) (bgp (?x ?p1 ?o1))))");
    }

    @Test
    public void inequality01() {
        this.testOp("(filter (!= ?x <x>) (bgp ( ?s ?p ?x)) )", this.t_inequality, "(minus (bgp ( ?s ?p ?x)) (table (vars ?x) (row [?x <x>])))");
    }

    @Test
    public void inequality02() {
        this.testOp("(filter (!= ?x 'x') (bgp ( ?s ?p ?x)) )", this.t_inequality, null);
    }

    @Test
    public void inequality03() {
        this.testOp("(filter (!= ?x 123) (bgp ( ?s ?p ?x)) )", this.t_inequality, null);
    }

    @Test
    public void inequality04() {
        this.testOp("(filter (!= ?UNUSED <x>) (bgp ( ?s ?p ?x)) )", this.t_inequality, "(table empty)");
    }

    @Test
    public void inequality05() {
        this.testOp("(filter (!= ?x2 <x>) (conditional (bgp ( ?s1 ?p1 ?x1))  (bgp ( ?s2 ?p2 ?x2))))", this.t_equality, null);
    }

    @Test
    public void inequality06() {
        this.testOp("(filter (!= ?x <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x))))", this.t_inequality, "(minus (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x))) (table (vars ?x) (row [?x <x>])))");
    }

    @Test
    public void inequality07() {
        this.testOp("(filter (!= ?x <x>) (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))))", this.t_inequality, "(minus (conditional (bgp ( ?s ?p ?x))  (bgp ( ?s ?p ?x1))) (table (vars ?x) (row [?x <x>])))");
    }

    @Test
    public void inequality08() {
        this.testOp("(filter ((!= ?x <x>) (!= ?x <y>)) (bgp ( ?s ?p ?x)) )", this.t_inequality, "(minus (bgp (?s ?p ?x)) (table (vars ?p ?x) (row [?x <y>]) (row [?x <x>])))");
    }

    @Test
    public void inequality09() {
        this.testOp("(filter ((!= ?x <x>) (!= ?p <y>)) (bgp ( ?s ?p ?x)) )", this.t_inequality, "(minus (bgp (?s ?p ?x)) (table (vars ?p ?x) (row [?p <y>]) (row [?x <x>])))");
    }

    @Test
    public void inequality10() {
        this.testOp("(filter ((!= ?x <x>) (!= ?x <y>) (!= ?p <type>)) (bgp ( ?s ?p ?x)) )", this.t_inequality, "(minus (bgp (?s ?p ?x)) (table (vars ?p ?x) (row [?p <type>]) (row [?x <y>]) (row [?x <x>])))");
    }

    @Test
    public void inequality11() {
        this.testOp("(filter ((!= ?x <x>) (> ?x 10)) (bgp ( ?s ?p ?x)) )", this.t_inequality, "(filter (> ?x 10) (minus (bgp ( ?s ?p ?x)) (table (vars ?x) (row [?x <x>]))))");
    }
}

