/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformScopeRename;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Rename;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestVarRename
extends BaseTest {
    @Test
    public void rename_01() {
        TestVarRename.rename("(bgp (<s> <p> <o>))", "(bgp (<s> <p> <o>))", true, new String[0]);
    }

    @Test
    public void rename_02() {
        TestVarRename.rename("(bgp (<s> ?p <o>))", "(bgp (<s> ?/p <o>))", true, new String[0]);
    }

    @Test
    public void rename_03() {
        TestVarRename.rename("(bgp (?s ?p <o>))", "(bgp (?s ?/p <o>))", true, "s");
    }

    @Test
    public void rename_04() {
        TestVarRename.rename("(filter (+ ?s ?x) (bgp (?s ?p <o>)))", "(filter (+ ?s ?/x) (bgp (?s ?/p <o>)))", true, "s");
    }

    @Test
    public void rename_05() {
        TestVarRename.rename("(group ((?.1 (str ?x))) ((?.0 (count))) (bgp (triple ?x :p ?v)))", "(group ((?/.1 (str ?x))) ((?/.0 (count))) (bgp (triple ?x :p ?/v)))", true, "x");
    }

    @Test
    public void rename_06() {
        TestVarRename.rename("(group ((?.1 (str ?x))) ((?.0 (max ?v))) (bgp (triple ?x :p ?v)))", "(group ((?/.1 (str ?x))) ((?/.0 (max ?/v))) (bgp (triple ?x :p ?/v)))", true, "x");
    }

    @Test
    public void rename_07() {
        TestVarRename.rename("(assign ((?x (+ ?/a ?/b))) (table unit))", "(assign ((?/x (+ ?//a ?//b))) (table unit))", true, new String[0]);
    }

    @Test
    public void rename_08() {
        TestVarRename.rename("(assign ((?x (+ ?/a ?/b))) (table unit))", "(assign ((?/x (+ ?/a ?//b))) (table unit))", false, "/a");
    }

    @Test
    public void rename_09() {
        TestVarRename.rename("(project (?s ?p) (bgp (?s ?p ?o)))", "(project (?s ?/p) (bgp (?s ?/p ?/o)))", true, "s");
    }

    @Test
    public void rename_10() {
        TestVarRename.rename("(order (?s ?p) (bgp (?s ?p ?o)))", "(order (?s ?/p) (bgp (?s ?/p ?/o)))", true, "s");
    }

    @Test
    public void rename_11() {
        TestVarRename.rename("(project (?s) (order (?s ?p) (bgp (?s ?p ?o))))", "(project (?s) (order (?s ?/p) (bgp (?s ?/p ?/o))))", true, "s");
    }

    @Test
    public void rename_12() {
        TestVarRename.rename("(leftjoin (bgp (?s ?p ?o)) (bgp (?s ?p ?o1)) () )", "(leftjoin (bgp (?s ?/p ?o)) (bgp (?s ?/p ?/o1)) () )", true, "s", "o");
    }

    @Test
    public void rename_13() {
        TestVarRename.rename("(project (?s) (project (?s) (table (vars ?obj) (row [?obj 123])) ))", "(project (?s) (project (?s) (table (vars ?/obj) (row [?/obj 123])) ))", true, "s");
    }

    @Test
    public void rename_14() {
        TestVarRename.rename("(project (?z) (project (?z) (sequence (service <http://foo> (bgp (?c ?p ?z)) ) (bgp (?c ?q ?z)) ) ) )", "(project (?z) (project (?z) (sequence (service <http://foo> (bgp (?/c ?/p ?z)) ) (bgp (?/c ?/q ?z)) ) ) )", true, "z");
    }

    @Test
    public void rename_reverse_01() {
        TestVarRename.reverse("(project (?s ?/p) (bgp (?s ?/p ?/o)))", "(project (?s ?p) (bgp (?s ?p ?o)))", true);
    }

    @Test
    public void rename_reverse_02() {
        TestVarRename.reverse("(assign ((?/x (+ ?//a ?///b))) (table unit))", "(assign ((?x (+ ?a ?b))) (table unit))", true);
    }

    private static void reverse(String string, String string2, boolean repeatedly) {
        Op opOrig = SSE.parseOp((String)string);
        Op opExpected = SSE.parseOp((String)string2);
        Op opActual = Rename.reverseVarRename((Op)opOrig, (boolean)repeatedly);
        TestVarRename.assertEquals((Object)opExpected, (Object)opActual);
    }

    private static void rename(String string, String string2, boolean reversable, String ... varNames) {
        HashSet<Var> s = new HashSet<Var>();
        for (String vn : varNames) {
            s.add(Var.alloc((String)vn));
        }
        TestVarRename.rename(string, string2, reversable, s);
    }

    private static void rename(String string, String string2, boolean reversable, Set<Var> constant) {
        Op opOrig = SSE.parseOp((String)string);
        Op opExpected = SSE.parseOp((String)string2);
        Op opActual = Rename.renameVars((Op)opOrig, constant);
        TestVarRename.assertEquals((Object)opExpected, (Object)opActual);
        if (reversable) {
            Op opRebuilt = Rename.reverseVarRename((Op)opActual, (boolean)false);
            TestVarRename.assertEquals((Object)opOrig, (Object)opRebuilt);
        }
    }

    @Test
    public void query_rename_01() {
        String queryString = "SELECT ?x { ?s ?p ?o . { SELECT ?v { ?x ?y ?v {SELECT ?w { ?a ?y ?w }}} LIMIT 50 } }";
        String opExpectedString = "(project (?x)\n  (join\n    (bgp (triple ?s ?p ?o))\n    (slice _ 50\n      (project (?v)\n        (join\n          (bgp (triple ?/x ?/y ?v))\n          (project (?/w)\n            (bgp (triple ?//a ?//y ?/w))))))))";
        TestVarRename.checkRename(queryString, opExpectedString);
    }

    @Test
    public void query_rename_02() {
        String queryString = "SELECT ?x { ?s ?p ?o . { SELECT ?v { ?x ?y ?v {SELECT * { ?a ?y ?w }}} LIMIT 50 } }";
        String opExpectedString = "(project (?x)\n  (join\n    (bgp (triple ?s ?p ?o))\n    (slice _ 50\n      (project (?v)\n        (join (bgp (triple ?/x ?/y ?v)) (bgp (triple ?/a ?/y ?/w)))))))";
        TestVarRename.checkRename(queryString, opExpectedString);
    }

    @Test
    public void query_rename_03() {
        String queryString = "SELECT ?x { ?s ?p ?o . { SELECT * { ?x ?y ?v {SELECT ?w { ?a ?y ?w }}} LIMIT 50 } }";
        String opExpectedString = "(project (?x)\n  (join\n    (bgp (triple ?s ?p ?o))\n    (slice _ 50\n      (join\n        (bgp (triple ?x ?y ?v))\n        (project (?w)\n          (bgp (triple ?/a ?/y ?w)))))))";
        TestVarRename.checkRename(queryString, opExpectedString);
    }

    @Test
    public void query_rename_04() {
        String queryString = "SELECT * { ?s ?p ?o . { SELECT ?v { ?x ?y ?v {SELECT ?w { ?a ?y ?w }}} LIMIT 50 } }";
        String opExpectedString = "(join\n  (bgp (triple ?s ?p ?o))\n  (slice _ 50\n    (project (?v)\n      (join\n        (bgp (triple ?/x ?/y ?v))\n        (project (?/w)\n          (bgp (triple ?//a ?//y ?/w)))))))";
        TestVarRename.checkRename(queryString, opExpectedString);
    }

    @Test
    public void query_rename_05() {
        String queryString = "SELECT ?v { ?s ?p ?o . { SELECT ?v { ?x ?y ?v {SELECT ?w { ?a ?y ?w }}} LIMIT 50 } }";
        String opExpectedString = "(project (?v)\n  (join\n    (bgp (triple ?s ?p ?o))\n    (slice _ 50\n      (project (?v)\n        (join\n          (bgp (triple ?/x ?/y ?v))\n          (project (?/w)\n            (bgp (triple ?//a ?//y ?/w))))))))";
        TestVarRename.checkRename(queryString, opExpectedString);
    }

    @Test
    public void query_rename_06() {
        String queryString = "SELECT ?w { ?s ?p ?o . { SELECT ?w { ?x ?y ?v {SELECT ?w { ?a ?y ?w }}} } } LIMIT 50";
        String opExpectedString = "(slice _ 50\n  (project (?w)\n    (join\n      (bgp (triple ?s ?p ?o))\n      (project (?w)\n        (join\n          (bgp (triple ?/x ?/y ?/v))\n          (project (?w)\n            (bgp (triple ?//a ?//y ?w))))))))\n";
        TestVarRename.checkRename(queryString, opExpectedString);
    }

    @Test
    public void query_rename_07() {
        String queryString = "SELECT * { ?s ?p ?o . { SELECT ?w { ?x ?y ?v }}}";
        String opExpectedString = "(join\n  (bgp (triple ?s ?p ?o))\n  (project (?w)\n    (bgp (triple ?/x ?/y ?/v))))";
        TestVarRename.checkRename(queryString, opExpectedString);
    }

    static void checkRename(String queryString, String opExpectedString) {
        Op opExpected = SSE.parseOp((String)opExpectedString);
        queryString = "PREFIX : <http://example/>\n" + queryString;
        Query query = QueryFactory.create((String)queryString);
        Op op = Algebra.compile((Query)query);
        Op opRenamed = TransformScopeRename.transform((Op)op);
        TestVarRename.assertEquals((Object)opExpected, (Object)opRenamed);
    }
}

