/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.api;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.sparql.function.library.wait;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.Lib;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQueryExecutionTimeout1
extends BaseTest {
    static Graph g = SSE.parseGraph((String)"(graph (<s> <p> <o1>) (<s> <p> <o2>) (<s> <p> <o3>))");
    static DatasetGraph dsg = DatasetGraphFactory.createOneGraph((Graph)g);
    static Dataset ds = DatasetFactory.create((DatasetGraph)dsg);
    private static final String ns = "http://example/ns#";
    private static String prefix = "PREFIX f:       <http://example/ns#>\nPREFIX afn:     <http://jena.hpl.hp.com/ARQ/function#>\n";

    @BeforeClass
    public static void beforeClass() {
        FunctionRegistry.get().put("http://example/ns#wait", wait.class);
    }

    @AfterClass
    public static void afterClass() {
        FunctionRegistry.get().remove("http://example/ns#wait");
    }

    @Test
    public void timeout_01() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);
        qExec.setTimeout(50L, TimeUnit.MILLISECONDS);
        ResultSet rs = qExec.execSelect();
        Lib.sleep((int)120);
        TestQueryExecutionTimeout1.exceptionExpected(rs);
    }

    @Test
    public void timeout_02() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);
        qExec.setTimeout(50L, TimeUnit.MILLISECONDS);
        ResultSet rs = qExec.execSelect();
        rs.next();
        Lib.sleep((int)75);
        TestQueryExecutionTimeout1.exceptionExpected(rs);
    }

    @Test
    public void timeout_03() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);
        qExec.setTimeout(100L, TimeUnit.MILLISECONDS);
        ResultSet rs = qExec.execSelect();
        ResultSetFormatter.consume((ResultSet)rs);
        qExec.close();
        qExec.abort();
    }

    @Test
    public void timeout_04() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            qExec.setTimeout(50L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume((ResultSet)rs);
            Lib.sleep((int)100);
            rs.hasNext();
        }
    }

    @Test
    public void timeout_06() {
        String qs = prefix + "SELECT * { ?s ?p ?o FILTER f:wait(1) }";
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            qExec.setTimeout(100L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume((ResultSet)rs);
        }
    }

    @Test
    public void timeout_07() {
        String qs = prefix + "SELECT * { ?s ?p ?o FILTER f:wait(1) }";
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume((ResultSet)rs);
        }
    }

    @Test
    public void timeout_08() {
        String qs = prefix + "SELECT * { ?s ?p ?o FILTER f:wait(1) }";
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            qExec.setTimeout(-1L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume((ResultSet)rs);
        }
    }

    @Test
    public void timeout_09() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            qExec.setTimeout(500L, TimeUnit.MILLISECONDS, -1L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            rs.next();
            rs.next();
            TestQueryExecutionTimeout1.assertTrue((boolean)rs.hasNext());
            ResultSetFormatter.consume((ResultSet)rs);
        }
    }

    @Test
    public void timeout_10() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            qExec.setTimeout(100L, TimeUnit.MILLISECONDS, 100L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            rs.next();
            rs.next();
            TestQueryExecutionTimeout1.assertTrue((boolean)rs.hasNext());
            Lib.sleep((int)200);
            TestQueryExecutionTimeout1.exceptionExpected(rs);
        }
    }

    @Test
    public void timeout_11() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            qExec.setTimeout(-1L, TimeUnit.MILLISECONDS, 100L, TimeUnit.MILLISECONDS);
            ResultSet rs = qExec.execSelect();
            rs.next();
            rs.next();
            Lib.sleep((int)200);
            TestQueryExecutionTimeout1.exceptionExpected(rs);
        }
    }

    @Test
    public void timeout_20() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        ARQ.getContext().set(ARQ.queryTimeout, (Object)"20");
        QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);
        ResultSet rs = qExec.execSelect();
        Lib.sleep((int)50);
        TestQueryExecutionTimeout1.exceptionExpected(rs);
    }

    @Test
    public void timeout_21() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        ARQ.getContext().set(ARQ.queryTimeout, (Object)"20,10");
        QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);
        ResultSet rs = qExec.execSelect();
        Lib.sleep((int)50);
        TestQueryExecutionTimeout1.exceptionExpected(rs);
    }

    @Test
    public void timeout_22() {
        String qs = prefix + "SELECT * { ?s ?p ?o }";
        ARQ.getContext().set(ARQ.queryTimeout, (Object)"-1");
        try (QueryExecution qExec = QueryExecutionFactory.create((String)qs, (Dataset)ds);){
            ResultSet rs = qExec.execSelect();
            ResultSetFormatter.consume((ResultSet)rs);
        }
    }

    private static void exceptionExpected(ResultSet rs) {
        try {
            ResultSetFormatter.consume((ResultSet)rs);
            TestQueryExecutionTimeout1.fail((String)"QueryCancelledException expected");
        }
        catch (QueryCancelledException queryCancelledException) {
            // empty catch block
        }
    }
}

