/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class AbstractTestDataset
extends BaseTest {
    static Model model1 = ModelFactory.createDefaultModel();
    static Model model2 = ModelFactory.createDefaultModel();
    static Resource s1 = model1.createResource("s1");
    static Resource s2 = model1.createResource("s2");
    static Property p1 = model1.createProperty("p1");
    static Property p2 = model1.createProperty("p2");
    static Resource o1 = model1.createResource("o1");
    static Resource o2 = model1.createResource("o2");

    protected abstract Dataset createFixed();

    @Test
    public void dataset_01() {
        Dataset ds = this.createFixed();
        AbstractTestDataset.assertNotNull((Object)ds.getDefaultModel());
        AbstractTestDataset.assertNotNull((Object)ds.asDatasetGraph());
    }

    @Test
    public void dataset_02() {
        Dataset ds = this.createFixed();
        ds.getDefaultModel().add(s1, p1, (RDFNode)o1);
        AbstractTestDataset.assertTrue((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void dataset_03() {
        Dataset ds = this.createFixed();
        ds.setDefaultModel(model2);
        AbstractTestDataset.assertTrue((boolean)model2.isIsomorphicWith(ds.getDefaultModel()));
    }

    @Test
    public void dataset_04() {
        String graphName = "http://example/";
        Dataset ds = this.createFixed();
        ds.addNamedModel(graphName, model1);
        AbstractTestDataset.assertTrue((boolean)ds.containsNamedModel(graphName));
        List x = Iter.toList((Iterator)ds.listNames());
        AbstractTestDataset.assertEquals((long)1L, (long)x.size());
        AbstractTestDataset.assertEquals((Object)graphName, x.get(0));
        AbstractTestDataset.assertFalse((boolean)model1.isIsomorphicWith(ds.getDefaultModel()));
        Model m = ds.getNamedModel(graphName);
        AbstractTestDataset.assertNotNull((Object)m);
        AbstractTestDataset.assertTrue((boolean)model1.isIsomorphicWith(m));
        ds.removeNamedModel(graphName);
        AbstractTestDataset.assertFalse((boolean)ds.containsNamedModel(graphName));
    }

    @Test
    public void dataset_05() {
        String graphName = "http://example/";
        Dataset ds = this.createFixed();
        ds.addNamedModel(graphName, model1);
        ds.replaceNamedModel(graphName, model2);
        AbstractTestDataset.assertTrue((boolean)ds.containsNamedModel(graphName));
        List x = Iter.toList((Iterator)ds.listNames());
        AbstractTestDataset.assertEquals((long)1L, (long)x.size());
        AbstractTestDataset.assertEquals((Object)graphName, x.get(0));
        AbstractTestDataset.assertFalse((boolean)model1.isIsomorphicWith(ds.getNamedModel(graphName)));
        AbstractTestDataset.assertTrue((boolean)model2.isIsomorphicWith(ds.getNamedModel(graphName)));
    }

    static {
        model1.add(s1, p1, (RDFNode)o1);
        model2.add(s2, p2, (RDFNode)o2);
    }
}

