/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.AbstractTestDataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraphWithLock;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class TestDatasetGraphWithLock
extends AbstractTestDataset {
    @Override
    protected Dataset createFixed() {
        return DatasetFactory.create((DatasetGraph)new DatasetGraphWithLock(DatasetGraphFactory.createMem()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void dsg_with_lock_concurrency_01() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            final DatasetGraphWithLock dsg = new DatasetGraphWithLock(DatasetGraphFactory.createMem());
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    dsg.begin(ReadWrite.READ);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    dsg.commit();
                    return true;
                }
            };
            Future<Boolean> f1 = executor.submit(callable);
            Future<Boolean> f2 = executor.submit(callable);
            Assert.assertTrue((boolean)f1.get(4L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)f2.get(4L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void dsg_with_lock_concurrency_02() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            final DatasetGraphWithLock dsg = new DatasetGraphWithLock(DatasetGraphFactory.createMem());
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    dsg.begin(ReadWrite.READ);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    dsg.commit();
                    return true;
                }
            };
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
            for (int i = 0; i < 100; ++i) {
                futures.add(executor.submit(callable));
            }
            for (Future future : futures) {
                Assert.assertTrue((boolean)((Boolean)future.get(3L, TimeUnit.SECONDS)));
            }
        }
        finally {
            executor.shutdownNow();
        }
    }
}

