/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.sparql.core.DatasetChanges;
import com.hp.hpl.jena.sparql.core.DatasetChangesCapture;
import com.hp.hpl.jena.sparql.core.DatasetChangesCounter;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraphMonitor;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadAction;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.List;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.Pair;
import org.junit.Test;

public class TestDatasetMonitor
extends BaseTest {
    static Quad quad1 = SSE.parseQuad((String)"(_ <s> <p> 1)");
    static Quad quad2 = SSE.parseQuad((String)"(<g> <s> <p> 2)");
    static Quad quad3 = SSE.parseQuad((String)"(<g> <s> <p> 3)");
    static Quad quad4 = SSE.parseQuad((String)"(<g> <s> <p> 4)");

    @Test
    public void countChanges_01() {
        DatasetGraph dsgBase = DatasetGraphFactory.createMem();
        DatasetChangesCounter dsgChanges = new DatasetChangesCounter();
        DatasetGraphMonitor dsg = new DatasetGraphMonitor(dsgBase, (DatasetChanges)dsgChanges);
        TestDatasetMonitor.check(dsgChanges, 0L, 0L, 0L, 0L);
        dsg.add(quad1);
        TestDatasetMonitor.check(dsgChanges, 1L, 0L, 0L, 0L);
    }

    @Test
    public void countChanges_02() {
        DatasetGraph dsgBase = DatasetGraphFactory.createMem();
        DatasetChangesCounter dsgChanges = new DatasetChangesCounter();
        DatasetGraphMonitor dsg = new DatasetGraphMonitor(dsgBase, (DatasetChanges)dsgChanges);
        TestDatasetMonitor.check(dsgChanges, 0L, 0L, 0L, 0L);
        dsg.add(quad1);
        dsg.delete(quad1);
        TestDatasetMonitor.check(dsgChanges, 1L, 1L, 0L, 0L);
    }

    @Test
    public void countChanges_03() {
        DatasetGraph dsgBase = DatasetGraphFactory.createMem();
        DatasetChangesCounter dsgChanges = new DatasetChangesCounter();
        DatasetGraphMonitor dsg = new DatasetGraphMonitor(dsgBase, (DatasetChanges)dsgChanges);
        TestDatasetMonitor.check(dsgChanges, 0L, 0L, 0L, 0L);
        dsg.add(quad1);
        dsg.add(quad1);
        dsg.delete(quad1);
        dsg.delete(quad1);
        TestDatasetMonitor.check(dsgChanges, 1L, 1L, 1L, 1L);
    }

    @Test
    public void countChanges_04() {
        DatasetGraph dsgBase = DatasetGraphFactory.createMem();
        DatasetChangesCounter dsgChanges = new DatasetChangesCounter();
        DatasetGraphMonitor dsg = new DatasetGraphMonitor(dsgBase, (DatasetChanges)dsgChanges);
        TestDatasetMonitor.check(dsgChanges, 0L, 0L, 0L, 0L);
        dsg.add(quad1);
        dsg.delete(quad1);
        dsg.add(quad1);
        dsg.delete(quad1);
        TestDatasetMonitor.check(dsgChanges, 2L, 2L, 0L, 0L);
    }

    @Test
    public void captureChanges_01() {
        DatasetGraph dsgBase = DatasetGraphFactory.createMem();
        DatasetChangesCapture dsgCapture = new DatasetChangesCapture();
        DatasetGraphMonitor dsg = new DatasetGraphMonitor(dsgBase, (DatasetChanges)dsgCapture);
        dsg.add(quad1);
        dsg.delete(quad1);
        dsg.add(quad2);
        dsg.add(quad2);
        List record = dsgCapture.getActions();
        TestDatasetMonitor.assertEquals((long)3L, (long)record.size());
        TestDatasetMonitor.check(record, 0, QuadAction.ADD, quad1);
        TestDatasetMonitor.check(record, 1, QuadAction.DELETE, quad1);
        TestDatasetMonitor.check(record, 2, QuadAction.ADD, quad2);
    }

    @Test
    public void captureChanges_02() {
        DatasetGraph dsgBase = DatasetGraphFactory.createMem();
        DatasetChangesCapture dsgCapture = new DatasetChangesCapture(true);
        DatasetGraphMonitor dsg = new DatasetGraphMonitor(dsgBase, (DatasetChanges)dsgCapture);
        dsg.add(quad1);
        dsg.delete(quad1);
        dsg.delete(quad1);
        dsg.add(quad2);
        dsg.add(quad2);
        List record = dsgCapture.getActions();
        TestDatasetMonitor.assertEquals((long)5L, (long)record.size());
        TestDatasetMonitor.check(record, 0, QuadAction.ADD, quad1);
        TestDatasetMonitor.check(record, 1, QuadAction.DELETE, quad1);
        TestDatasetMonitor.check(record, 2, QuadAction.NO_DELETE, quad1);
        TestDatasetMonitor.check(record, 3, QuadAction.ADD, quad2);
        TestDatasetMonitor.check(record, 4, QuadAction.NO_ADD, quad2);
    }

    private static void check(DatasetChangesCounter changes, long adds, long deletes, long noAdds, long noDeletes) {
        TestDatasetMonitor.assertEquals((String)"Adds", (long)adds, (long)changes.countAdd);
        TestDatasetMonitor.assertEquals((String)"Deletes", (long)deletes, (long)changes.countDelete);
        TestDatasetMonitor.assertEquals((String)"NoAdds", (long)noAdds, (long)changes.countNoAdd);
        TestDatasetMonitor.assertEquals((String)"NoDeletes", (long)noDeletes, (long)changes.countNoDelete);
    }

    private static void check(List<Pair<QuadAction, Quad>> record, int indx, QuadAction quadAction, Quad quad) {
        TestDatasetMonitor.assertTrue((String)("Index " + indx + " out of range [0," + record.size() + ")"), (0 <= indx && indx < record.size() ? 1 : 0) != 0);
        Pair<QuadAction, Quad> pair = record.get(indx);
        TestDatasetMonitor.assertEquals((Object)quadAction, (Object)pair.getLeft());
        TestDatasetMonitor.assertEquals((Object)quad, (Object)pair.getRight());
    }
}

