/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSort;
import com.hp.hpl.jena.sparql.engine.main.OpExecutorFactory;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.jena.atlas.data.DataBagExaminer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueryIterSort {
    private static final String LETTERS = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    private Random random;
    private List<Binding> unsorted;
    private BindingComparator comparator;
    private CallbackIterator iterator;

    @Before
    public void setup() {
        this.random = new Random();
        Var[] vars = new Var[]{Var.alloc((String)"1"), Var.alloc((String)"2"), Var.alloc((String)"3"), Var.alloc((String)"4"), Var.alloc((String)"5"), Var.alloc((String)"6"), Var.alloc((String)"7"), Var.alloc((String)"8"), Var.alloc((String)"9"), Var.alloc((String)"0")};
        this.unsorted = new ArrayList<Binding>();
        for (int i = 0; i < 500; ++i) {
            this.unsorted.add(this.randomBinding(vars));
        }
        ArrayList<SortCondition> conditions = new ArrayList<SortCondition>();
        conditions.add(new SortCondition((Expr)new ExprVar("8"), 1));
        this.comparator = new BindingComparator(conditions);
        this.iterator = new CallbackIterator(this.unsorted.iterator(), 25, null);
        this.iterator.setCallback(new Callback(){

            @Override
            public void call() {
                throw new QueryCancelledException();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSpill() {
        this.iterator.setCallback(new Callback(){

            @Override
            public void call() {
            }
        });
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanAfterClose() {
        this.iterator.setCallback(new Callback(){

            @Override
            public void call() {
            }
        });
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test
    public void testCleanAfterExhaustion() {
        this.iterator.setCallback(new Callback(){

            @Override
            public void call() {
            }
        });
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        qIter.hasNext();
        Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
        Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        while (qIter.hasNext()) {
            qIter.next();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
        qIter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsInitialisation() {
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);
        try {
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.cancel();
            qIter.hasNext();
        }
        finally {
            Assert.assertTrue((boolean)this.iterator.isCanceled());
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.close();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsExternalSortAfterStartingIteration() {
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        try (QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);){
            Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.hasNext();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=QueryCancelledException.class)
    public void testCancelInterruptsExternalSortAtStartOfIteration() {
        this.iterator = new CallbackIterator(this.unsorted.iterator(), 25, null);
        this.iterator.setCallback(new Callback(){

            @Override
            public void call() {
            }
        });
        Assert.assertEquals((long)0L, (long)this.iterator.getReturnedElementCount());
        Context context = new Context();
        context.set(ARQ.spillToDiskThreshold, (Object)10L);
        ExecutionContext executionContext = new ExecutionContext(context, (Graph)null, (DatasetGraph)null, (OpExecutorFactory)null);
        QueryIterSort qIter = new QueryIterSort((QueryIterator)this.iterator, (Comparator)this.comparator, executionContext);
        try {
            Assert.assertTrue((boolean)qIter.hasNext());
            Assert.assertEquals((long)49L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            Assert.assertNotNull((Object)qIter.next());
            Assert.assertTrue((boolean)qIter.hasNext());
            qIter.cancel();
            qIter.hasNext();
        }
        finally {
            Assert.assertEquals((long)500L, (long)this.iterator.getReturnedElementCount());
            Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
            qIter.close();
        }
        Assert.assertEquals((long)0L, (long)DataBagExaminer.countTemporaryFiles(qIter.db));
    }

    private Binding randomBinding(Var[] vars) {
        BindingMap binding = BindingFactory.create();
        binding.add(vars[0], NodeFactory.createAnon());
        binding.add(vars[1], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[2], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[3], NodeFactory.createLiteral((String)this.randomString(20)));
        binding.add(vars[4], NodeFactory.createAnon());
        binding.add(vars[5], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[6], NodeFactory.createURI((String)this.randomURI()));
        binding.add(vars[7], NodeFactory.createLiteral((String)this.randomString(5)));
        binding.add(vars[8], NodeFactory.createLiteral((String)("" + this.random.nextInt()), (RDFDatatype)XSDDatatype.XSDinteger));
        binding.add(vars[9], NodeFactory.createAnon());
        return binding;
    }

    private String randomURI() {
        return String.format("http://%s.example.com/%s", this.randomString(10), this.randomString(10));
    }

    private String randomString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(LETTERS.charAt(this.random.nextInt(LETTERS.length())));
        }
        return builder.toString();
    }

    private static interface Callback {
        public void call();
    }

    private class CallbackIterator
    implements QueryIterator {
        int elementsReturned = 0;
        Callback callback;
        int trigger;
        Iterator<Binding> delegate;
        boolean canceled = false;

        public CallbackIterator(Iterator<Binding> delegate, int trigger, Callback callback) {
            this.delegate = delegate;
            this.callback = callback;
            this.trigger = trigger;
        }

        public void setCallback(Callback callback) {
            this.callback = callback;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Binding next() {
            if (this.elementsReturned++ >= this.trigger) {
                this.callback.call();
            }
            return this.delegate.next();
        }

        public void remove() {
            this.delegate.remove();
        }

        public int getReturnedElementCount() {
            return this.elementsReturned;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public Binding nextBinding() {
            if (this.elementsReturned++ >= this.trigger) {
                this.callback.call();
            }
            return this.delegate.next();
        }

        public void cancel() {
            this.canceled = true;
        }

        public void close() {
            throw new ARQNotImplemented();
        }

        public void output(IndentedWriter out, SerializationContext sCxt) {
            throw new ARQNotImplemented();
        }

        public String toString(PrefixMapping pmap) {
            throw new ARQNotImplemented();
        }

        public void output(IndentedWriter out) {
            throw new ARQNotImplemented();
        }
    }
}

