/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCustom;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateRegistry;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorFactory;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.sparql.sse.SSE;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCustomAggregates
extends BaseTest {
    public static final String aggIRI = "http://example.test/agg";
    public static final String aggIRI2 = "http://example.test/aggUnRegistered";
    static AccumulatorFactory myAccumulatorFactory = new AccumulatorFactory(){

        public Accumulator createAccumulator(AggCustom agg) {
            return new MyAccumulator(agg);
        }
    };

    @BeforeClass
    public static void setup() {
        AggregateRegistry.register((String)aggIRI, (AccumulatorFactory)myAccumulatorFactory, (Node)NodeConst.nodeMinusOne);
    }

    @AfterClass
    public static void clearup() {
        AggregateRegistry.unregister((String)aggIRI);
    }

    @Test
    public void customAgg_1() {
        TestCustomAggregates.assertTrue((boolean)AggregateRegistry.isRegistered((String)aggIRI));
    }

    @Test
    public void customAgg_2() {
        TestCustomAggregates.assertFalse((boolean)AggregateRegistry.isRegistered((String)aggIRI2));
    }

    @Test
    public void customAgg_10() {
        String qs = "SELECT (AGG <http://example.test/agg>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
        Query q = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        String qs2 = q.serialize(Syntax.syntaxARQ);
        Query q2 = QueryFactory.create((String)qs2, (Syntax)Syntax.syntaxARQ);
        TestCustomAggregates.assertEquals((Object)q, (Object)q2);
    }

    @Test
    public void customAgg_11() {
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
        Query q = QueryFactory.create((String)qs);
        String qs2 = q.serialize();
        Query q2 = QueryFactory.create((String)qs2);
        TestCustomAggregates.assertEquals((Object)q, (Object)q2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customAgg_12() {
        LogCtl.setError(AggregatorFactory.class);
        try {
            String qs = "SELECT (AGG <http://example.test/aggUnRegistered>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
            Query q = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
            String qs2 = q.serialize(Syntax.syntaxARQ);
            Query q2 = QueryFactory.create((String)qs2, (Syntax)Syntax.syntaxARQ);
            TestCustomAggregates.assertEquals((Object)q, (Object)q2);
        }
        finally {
            LogCtl.setInfo(AggregatorFactory.class);
        }
    }

    @Test
    public void customAgg_20() {
        Graph g = SSE.parseGraph((String)"(graph (:s :p :o) (:s :p 1))");
        Model m = ModelFactory.createModelForGraph((Graph)g);
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o } GROUP BY ?s";
        Query q = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);){
            ResultSet rs = qExec.execSelect();
            QuerySolution soln = rs.nextSolution();
            TestCustomAggregates.assertFalse((boolean)rs.hasNext());
            int v = soln.getLiteral("x").getInt();
            TestCustomAggregates.assertEquals((long)1L, (long)v);
        }
    }

    @Test
    public void customAgg_21() {
        Graph g = SSE.parseGraph((String)"(graph (:s :p :o) (:s :p 1))");
        Model m = ModelFactory.createModelForGraph((Graph)g);
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o FILTER (false) } GROUP BY ?s";
        Query q = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)m);){
            ResultSet rs = qExec.execSelect();
            QuerySolution soln = rs.nextSolution();
            TestCustomAggregates.assertFalse((boolean)rs.hasNext());
            int v = soln.getLiteral("x").getInt();
            TestCustomAggregates.assertEquals((long)-1L, (long)v);
        }
    }

    @Test
    public void customAgg_22() {
        String qs = "SELECT (<http://example.test/agg>(?o) AS ?x) {?s ?p ?o }";
        Query q = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        Op op = Algebra.compile((Query)q);
        String x = StrUtils.strjoinNL((String[])new String[]{"(project (?x)", "   (extend ((?x ?.0))", "       (group () ((?.0 (agg <http://example.test/agg> ?o)))", "         (bgp (triple ?s ?p ?o)))))"});
        Op op2 = SSE.parseOp((String)x);
        TestCustomAggregates.assertEquals((Object)op2, (Object)op);
    }

    static class MyAccumulator
    implements Accumulator {
        int count = 0;
        private AggCustom agg;

        MyAccumulator(AggCustom agg) {
            this.agg = agg;
        }

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ExprList exprList = this.agg.getExprList();
            for (Expr expr : exprList) {
                try {
                    NodeValue nv = expr.eval(binding, functionEnv);
                    if (!nv.isLiteral()) continue;
                    ++this.count;
                }
                catch (ExprEvalException ex) {}
            }
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger((long)this.count);
        }
    }
}

