/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLeviathanFunctions
extends BaseTest {
    static boolean warnOnBadLexicalForms = true;
    private static PrefixMapping pmap = new PrefixMappingImpl();
    private static SerializationContext serContext = new SerializationContext(false);

    @BeforeClass
    public static void beforeClass() {
        warnOnBadLexicalForms = NodeValue.VerboseWarnings;
        NodeValue.VerboseWarnings = false;
    }

    @AfterClass
    public static void afterClass() {
        NodeValue.VerboseWarnings = warnOnBadLexicalForms;
    }

    @Test
    public void sq_01() {
        TestLeviathanFunctions.test("lfn:sq(2)", "4");
    }

    @Test
    public void sq_02() {
        TestLeviathanFunctions.test("lfn:sq(3)", "9");
    }

    @Test
    public void sq_03() {
        TestLeviathanFunctions.test("lfn:sq(0.5)", "0.25");
    }

    @Test
    public void cube_01() {
        TestLeviathanFunctions.test("lfn:cube(2)", "8");
    }

    @Test
    public void cube_02() {
        TestLeviathanFunctions.test("lfn:cube(3)", "27");
    }

    @Test
    public void cube_03() {
        TestLeviathanFunctions.test("lfn:cube(0.5)", "0.125");
    }

    @Test
    public void e_01() {
        TestLeviathanFunctions.test("lfn:e(2)", NodeFactoryExtra.doubleToNode((double)Math.exp(2.0)));
    }

    @Test
    public void pow_01() {
        TestLeviathanFunctions.test("lfn:pow(2, 4)", "16");
    }

    @Test
    public void pow_02() {
        TestLeviathanFunctions.test("lfn:pow(0.5, 3)", "0.125");
    }

    private static void test(String string, String result) {
        Node r = NodeFactoryExtra.parseNode((String)result);
        TestLeviathanFunctions.test(string, r);
    }

    private static void test(String string, Node result) {
        Expr expr = ExprUtils.parse((String)string, (PrefixMapping)pmap);
        NodeValue nv = expr.eval(null, (FunctionEnv)new FunctionEnvBase());
        NodeValue nvr = NodeValue.makeNode((Node)result);
        TestLeviathanFunctions.assertTrue((String)("Not same value: Expected: " + nvr + " : Actual = " + nv), (boolean)NodeValue.sameAs((NodeValue)nvr, (NodeValue)nv));
    }

    static {
        pmap.setNsPrefixes(ARQConstants.getGlobalPrefixMap());
        pmap.setNsPrefix("lfn", "http://www.dotnetrdf.org/leviathan#");
    }
}

