/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRegex
extends BaseTest {
    @BeforeClass
    public static void beforeClass() {
    }

    @Test
    public void testRegex1() {
        this.regexTest("ABC", "ABC", null, true);
    }

    @Test
    public void testRegex2() {
        this.regexTest("ABC", "abc", null, false);
    }

    @Test
    public void testRegex3() {
        this.regexTest("ABC", "abc", "", false);
    }

    @Test
    public void testRegex4() {
        this.regexTest("ABC", "abc", "i", true);
    }

    @Test
    public void testRegex5() {
        this.regexTest("abc", "B", "i", true);
    }

    @Test
    public void testRegex6() {
        this.regexTest("ABC", "^ABC", null, true);
    }

    @Test
    public void testRegex7() {
        this.regexTest("ABC", "BC", null, true);
    }

    @Test
    public void testRegex8() {
        this.regexTest("ABC", "^BC", null, false);
    }

    public void regexTest(String value, String pattern, String flags, boolean expected) {
        NodeValue s = NodeValue.makeString((String)value);
        E_Regex r = new E_Regex((Expr)s, pattern, flags);
        NodeValue nv = r.eval(BindingFactory.binding(), null);
        boolean b = nv.getBoolean();
        if (b != expected) {
            TestRegex.fail((String)(this.fmtTest(value, pattern, flags) + " ==> " + b + " expected " + expected));
        }
    }

    private String fmtTest(String value, String pattern, String flags) {
        String tmp = "regex(\"" + value + "\", \"" + pattern + "\"";
        if (flags != null) {
            tmp = tmp + "\"" + flags + "\"";
        }
        tmp = tmp + ")";
        return tmp;
    }
}

