/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.user;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.expr.E_Add;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.E_Multiply;
import com.hp.hpl.jena.sparql.expr.E_Subtract;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueBoolean;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunction;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionDefinition;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionFactory;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFunctionExpansion {
    @BeforeClass
    public static void setup() {
        UserDefinedFunctionFactory.getFactory().clear();
        UserDefinedFunctionFactory.getFactory().setPreserveDependencies(false);
    }

    @AfterClass
    public static void teardown() {
        UserDefinedFunctionFactory.getFactory().clear();
        UserDefinedFunctionFactory.getFactory().setPreserveDependencies(false);
    }

    @Test
    public void test_function_expansion_01() {
        ExprVar e = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/simple", (Expr)e, new ArrayList(e.getVarsMentioned()));
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/simple");
        f.build("http://example/simple", new ExprList((Expr)new NodeValueBoolean(true)));
        Expr actual = f.getActualExpr();
        Assert.assertFalse((boolean)e.equals(actual));
        Assert.assertEquals((long)0L, (long)actual.getVarsMentioned().size());
        Assert.assertEquals((Object)new NodeValueBoolean(true), (Object)actual);
    }

    @Test
    public void test_function_expansion_02() {
        E_Multiply e = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)e, new ArrayList(e.getVarsMentioned()));
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/square");
        f.build("http://example/square", new ExprList((Expr)new NodeValueInteger(3L)));
        Expr actual = f.getActualExpr();
        Assert.assertFalse((boolean)e.equals(actual));
        Assert.assertEquals((long)0L, (long)actual.getVarsMentioned().size());
        Assert.assertEquals((Object)new E_Multiply((Expr)new NodeValueInteger(3L), (Expr)new NodeValueInteger(3L)), (Object)actual);
    }

    @Test
    public void test_function_expansion_03() {
        E_Multiply e = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("y"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc((String)"x"));
        defArgs.add(Var.alloc((String)"y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)e, defArgs);
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/square");
        ExprList args = new ExprList();
        args.add((Expr)new NodeValueInteger(3L));
        args.add((Expr)new NodeValueInteger(4L));
        f.build("http://example/square", args);
        Expr actual = f.getActualExpr();
        Assert.assertFalse((boolean)e.equals(actual));
        Assert.assertEquals((long)0L, (long)actual.getVarsMentioned().size());
        Assert.assertEquals((Object)new E_Multiply((Expr)new NodeValueInteger(3L), (Expr)new NodeValueInteger(4L)), (Object)actual);
    }

    @Test
    public void test_function_expansion_04() {
        E_Multiply square = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
        E_Multiply cube = new E_Multiply((Expr)new E_Function("http://example/square", new ExprList((Expr)new ExprVar("x"))), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", (Expr)cube, new ArrayList(cube.getVarsMentioned()));
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/cube");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Multiply));
        E_Multiply m = (E_Multiply)base;
        Assert.assertTrue((boolean)(m.getArg1() instanceof E_Multiply));
        Assert.assertTrue((boolean)(m.getArg2() instanceof ExprVar));
        Assert.assertEquals((long)1L, (long)base.getVarsMentioned().size());
    }

    @Test
    public void test_function_expansion_05() {
        E_Multiply square = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
        E_Multiply cube = new E_Multiply((Expr)new E_Function("http://example/square", new ExprList((Expr)new ExprVar("y"))), (Expr)new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", (Expr)cube, new ArrayList(cube.getVarsMentioned()));
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/cube");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Multiply));
        E_Multiply m = (E_Multiply)base;
        Assert.assertTrue((boolean)(m.getArg1() instanceof E_Multiply));
        Assert.assertTrue((boolean)(m.getArg2() instanceof ExprVar));
        Assert.assertEquals((long)1L, (long)base.getVarsMentioned().size());
    }

    @Test
    public void test_function_expansion_06() {
        E_Subtract takeaway = new E_Subtract((Expr)new ExprVar("x"), (Expr)new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", (Expr)takeaway, args);
        ExprList numArgs = new ExprList();
        numArgs.add((Expr)new NodeValueInteger(1L));
        numArgs.add((Expr)new NodeValueDouble(2.3));
        E_Function test = new E_Function("http://example/takeaway", numArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", (Expr)test, new ArrayList());
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof NodeValueInteger));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof NodeValueDouble));
    }

    @Test
    public void test_function_expansion_07() {
        E_Subtract takeaway = new E_Subtract((Expr)new ExprVar("x"), (Expr)new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", (Expr)takeaway, args);
        ExprList numArgs = new ExprList();
        numArgs.add((Expr)new NodeValueDouble(2.3));
        numArgs.add((Expr)new NodeValueInteger(1L));
        E_Function test = new E_Function("http://example/takeaway", numArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", (Expr)test, new ArrayList());
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof NodeValueDouble));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof NodeValueInteger));
    }

    @Test
    public void test_function_expansion_08() {
        E_Subtract takeaway = new E_Subtract((Expr)new ExprVar("x"), (Expr)new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", (Expr)takeaway, args);
        ExprList altArgs = new ExprList();
        altArgs.add((Expr)new ExprVar("a"));
        altArgs.add((Expr)new ExprVar("b"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc((String)"a"));
        defArgs.add(Var.alloc((String)"b"));
        E_Function test = new E_Function("http://example/takeaway", altArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", (Expr)test, defArgs);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)subtract.getArg1().getVarName(), (Object)"a");
        Assert.assertEquals((Object)subtract.getArg2().getVarName(), (Object)"b");
    }

    @Test
    public void test_function_expansion_09() {
        E_Subtract takeaway = new E_Subtract((Expr)new ExprVar("x"), (Expr)new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", (Expr)takeaway, args);
        ExprList altArgs = new ExprList();
        altArgs.add((Expr)new ExprVar("b"));
        altArgs.add((Expr)new ExprVar("a"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc((String)"a"));
        defArgs.add(Var.alloc((String)"b"));
        E_Function test = new E_Function("http://example/takeaway", altArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", (Expr)test, defArgs);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)subtract.getArg1().getVarName(), (Object)"b");
        Assert.assertEquals((Object)subtract.getArg2().getVarName(), (Object)"a");
    }

    @Test
    public void test_function_expansion_10() {
        ExprVar single = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/single", (Expr)single, new ArrayList(single.getVarsMentioned()));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        E_Add add = new E_Add((Expr)new E_Function("http://example/single", new ExprList((Expr)new ExprVar("x"))), (Expr)new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/add", (Expr)add, args);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/add");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Add));
        E_Add actual = (E_Add)base;
        Assert.assertTrue((boolean)(actual.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(actual.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)"x", (Object)actual.getArg1().getVarName());
        Assert.assertEquals((Object)"y", (Object)actual.getArg2().getVarName());
    }

    @Test
    public void test_function_expansion_11() {
        ExprVar single = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/single", (Expr)single, new ArrayList(single.getVarsMentioned()));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        E_Add add = new E_Add((Expr)new E_Function("http://example/single", new ExprList((Expr)new ExprVar("y"))), (Expr)new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/add", (Expr)add, args);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/add");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Add));
        E_Add actual = (E_Add)base;
        Assert.assertTrue((boolean)(actual.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(actual.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)"y", (Object)actual.getArg1().getVarName());
        Assert.assertEquals((Object)"y", (Object)actual.getArg2().getVarName());
    }

    @Test
    public void test_function_expansion_12() {
        E_Subtract takeaway = new E_Subtract((Expr)new ExprVar("x"), (Expr)new ExprVar("y"));
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/takeaway", (Expr)takeaway, args);
        ExprList altArgs = new ExprList();
        altArgs.add((Expr)new ExprVar("a"));
        altArgs.add((Expr)new ExprVar("a"));
        ArrayList<Var> defArgs = new ArrayList<Var>();
        defArgs.add(Var.alloc((String)"a"));
        defArgs.add(Var.alloc((String)"b"));
        E_Function test = new E_Function("http://example/takeaway", altArgs);
        UserDefinedFunctionFactory.getFactory().add("http://example/test", (Expr)test, defArgs);
        UserDefinedFunctionDefinition def = UserDefinedFunctionFactory.getFactory().get("http://example/test");
        Expr base = def.getBaseExpr();
        Assert.assertTrue((boolean)(base instanceof E_Subtract));
        E_Subtract subtract = (E_Subtract)base;
        Assert.assertTrue((boolean)(subtract.getArg1() instanceof ExprVar));
        Assert.assertTrue((boolean)(subtract.getArg2() instanceof ExprVar));
        Assert.assertEquals((Object)subtract.getArg1().getVarName(), (Object)"a");
        Assert.assertEquals((Object)subtract.getArg2().getVarName(), (Object)"a");
    }

    @Test
    public void test_function_expansion_13() {
        E_Multiply square = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
        E_Multiply cube = new E_Multiply((Expr)new E_Function("http://example/square", new ExprList((Expr)new ExprVar("x"))), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/cube", (Expr)cube, new ArrayList(cube.getVarsMentioned()));
        UserDefinedFunction f = (UserDefinedFunction)UserDefinedFunctionFactory.getFactory().create("http://example/cube");
        f.build("http://example/cube", new ExprList((Expr)new NodeValueInteger(2L)));
        Expr actual = f.getActualExpr();
        NodeValue result = actual.eval((Binding)BindingFactory.create(), FunctionEnvBase.createTest());
        Assert.assertEquals((long)8L, (long)NodeFactoryExtra.nodeToInt((Node)result.asNode()));
        square = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
        f.build("http://example/cube", new ExprList((Expr)new NodeValueInteger(2L)));
        actual = f.getActualExpr();
        result = actual.eval((Binding)BindingFactory.create(), FunctionEnvBase.createTest());
        Assert.assertEquals((long)8L, (long)NodeFactoryExtra.nodeToInt((Node)result.asNode()));
    }

    @Test(expected=ExprBuildException.class)
    public void test_function_expansion_bad_01() {
        ArrayList<Var> args = new ArrayList<Var>();
        args.add(Var.alloc((String)"x"));
        args.add(Var.alloc((String)"y"));
        E_Add add = new E_Add((Expr)new ExprVar("x"), (Expr)new ExprVar("y"));
        UserDefinedFunctionFactory.getFactory().add("http://example/add", (Expr)add, new ArrayList());
    }

    @Test(expected=ExprBuildException.class)
    public void test_function_expansion_bad_02() {
        ExprVar single = new ExprVar("x");
        UserDefinedFunctionFactory.getFactory().add("http://example/single", (Expr)single, new ArrayList(single.getVarsMentioned()));
        E_Function test = new E_Function("http://example/single", new ExprList((Expr)new ExprVar("x")));
        UserDefinedFunctionFactory.getFactory().add("http://example/test", (Expr)test, new ArrayList());
    }
}

