/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.user;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Multiply;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionFactory;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUserFunctionsInSparql {
    @BeforeClass
    public static void setup() {
        UserDefinedFunctionFactory.getFactory().clear();
        E_Multiply square = new E_Multiply((Expr)new ExprVar("x"), (Expr)new ExprVar("x"));
        UserDefinedFunctionFactory.getFactory().add("http://example/square", (Expr)square, new ArrayList(square.getVarsMentioned()));
    }

    @AfterClass
    public static void teardown() {
        UserDefinedFunctionFactory.getFactory().clear();
    }

    @Test
    public void test_user_functions_in_sparql() {
        Assert.assertTrue((boolean)UserDefinedFunctionFactory.getFactory().isRegistered("http://example/square"));
        String query = "SELECT (<http://example/square>(2) AS ?square) { }";
        Query q = QueryFactory.create((String)query);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)ModelFactory.createDefaultModel());){
            ResultSet rset = qe.execSelect();
            Assert.assertTrue((boolean)rset.hasNext());
            Binding b = rset.nextBinding();
            Assert.assertFalse((boolean)rset.hasNext());
            Node actual = b.get(Var.alloc((String)"square"));
            Assert.assertEquals((Object)NodeFactoryExtra.intToNode((int)4), (Object)actual);
        }
    }
}

