/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class AbstractTestGraph2
extends BaseTest {
    protected static final Node s1 = NodeFactoryExtra.parseNode((String)"<ex:s1>");
    protected static final Node p1 = NodeFactoryExtra.parseNode((String)"<ex:p1>");
    protected static final Node o1 = NodeFactoryExtra.parseNode((String)"<ex:o1>");
    protected static final Node s2 = NodeFactoryExtra.parseNode((String)"<ex:s2>");
    protected static final Node p2 = NodeFactoryExtra.parseNode((String)"<ex:p2>");
    protected static final Node o2 = NodeFactoryExtra.parseNode((String)"<ex:o2>");
    protected static final Node lit1 = NodeFactoryExtra.parseNode((String)"'lex'");
    protected static final Node lit2 = NodeFactoryExtra.parseNode((String)"'lex'@en");
    protected static final Node lit3 = NodeFactoryExtra.parseNode((String)"123");
    private static Node any = Node.ANY;

    static Triple triple(Node s, Node p, Node o) {
        return new Triple(s, p, o);
    }

    protected abstract Graph emptyGraph();

    protected abstract void returnGraph(Graph var1);

    @Test
    public void graph_01() {
        Graph g = this.emptyGraph();
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        this.returnGraph(g);
    }

    @Test
    public void graph_add_01() {
        Graph g = this.emptyGraph();
        Triple t = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t);
        AbstractTestGraph2.assertEquals((long)1L, (long)g.size());
        AbstractTestGraph2.assertTrue((boolean)g.contains(t));
        AbstractTestGraph2.assertTrue((boolean)g.contains(s1, p1, o1));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_02() {
        Graph g = this.emptyGraph();
        Triple t = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t);
        g.add(t);
        AbstractTestGraph2.assertEquals((long)1L, (long)g.size());
        AbstractTestGraph2.assertTrue((boolean)g.contains(t));
        AbstractTestGraph2.assertTrue((boolean)g.contains(s1, p1, o1));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_03() {
        Graph g = this.emptyGraph();
        Node ns1 = NodeFactoryExtra.parseNode((String)"<ex:s>");
        Node np1 = NodeFactoryExtra.parseNode((String)"<ex:p>");
        Node no1 = NodeFactoryExtra.parseNode((String)"<ex:o>");
        Node ns2 = NodeFactoryExtra.parseNode((String)"<ex:s>");
        Node np2 = NodeFactoryExtra.parseNode((String)"<ex:p>");
        Node no2 = NodeFactoryExtra.parseNode((String)"<ex:o>");
        Triple t1 = AbstractTestGraph2.triple(ns1, np1, no1);
        Triple t2 = AbstractTestGraph2.triple(ns2, np2, no2);
        g.add(t1);
        g.add(t2);
        AbstractTestGraph2.assertEquals((long)1L, (long)g.size());
        AbstractTestGraph2.assertTrue((boolean)g.contains(t1));
        AbstractTestGraph2.assertTrue((boolean)g.contains(t2));
        AbstractTestGraph2.assertTrue((boolean)g.contains(ns1, np1, no1));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_04() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, lit1);
        Triple t2 = AbstractTestGraph2.triple(s1, p1, lit2);
        g.add(t1);
        g.add(t2);
        AbstractTestGraph2.assertEquals((long)2L, (long)g.size());
        AbstractTestGraph2.assertTrue((boolean)g.contains(t1));
        AbstractTestGraph2.assertTrue((boolean)g.contains(t2));
        AbstractTestGraph2.assertTrue((boolean)g.contains(s1, p1, lit1));
        AbstractTestGraph2.assertTrue((boolean)g.contains(s1, p1, lit2));
        Node o = NodeFactoryExtra.parseNode((String)"<ex:lex>");
        AbstractTestGraph2.assertFalse((boolean)g.contains(s1, p1, o));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_delete_01() {
        Graph g = this.emptyGraph();
        Triple t = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t);
        g.delete(t);
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        AbstractTestGraph2.assertFalse((String)"g contains t", (boolean)g.contains(t));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_delete_02() {
        Graph g = this.emptyGraph();
        Triple t = AbstractTestGraph2.triple(s1, p1, o1);
        g.delete(t);
        g.add(t);
        AbstractTestGraph2.assertEquals((long)1L, (long)g.size());
        AbstractTestGraph2.assertTrue((String)"g does not contain t", (boolean)g.contains(t));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_delete_03() {
        Graph g = this.emptyGraph();
        Triple t = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t);
        g.add(t);
        g.delete(t);
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        AbstractTestGraph2.assertFalse((String)"g contains t", (boolean)g.contains(t));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_delete_04() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        Triple t2 = AbstractTestGraph2.triple(s2, p2, o2);
        g.add(t1);
        g.add(t2);
        g.delete(t1);
        AbstractTestGraph2.assertEquals((long)1L, (long)g.size());
        AbstractTestGraph2.assertTrue((String)"g does not contain t2", (boolean)g.contains(t2));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_find_01() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        AbstractTestGraph2.assertFalse((boolean)g.contains(t1));
        g.add(t1);
        AbstractTestGraph2.assertTrue((boolean)g.contains(t1));
        this.returnGraph(g);
    }

    @Test
    public void graph_add_find_02() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        AbstractTestGraph2.assertFalse((boolean)g.contains(t1));
        g.add(t1);
        AbstractTestGraph2.assertTrue((boolean)g.contains(t1));
        this.returnGraph(g);
    }

    @Test
    public void remove_01() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t1);
        g.remove(any, any, any);
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        this.returnGraph(g);
    }

    @Test
    public void remove_02() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t1);
        g.remove(s2, any, any);
        AbstractTestGraph2.assertEquals((long)1L, (long)g.size());
        AbstractTestGraph2.assertTrue((boolean)g.contains(t1));
        this.returnGraph(g);
    }

    @Test
    public void remove_03() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t1);
        g.remove(s1, any, any);
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        this.returnGraph(g);
    }

    @Test
    public void removeAll_01() {
        Graph g = this.emptyGraph();
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        Triple t2 = AbstractTestGraph2.triple(s1, p1, o2);
        Triple t3 = AbstractTestGraph2.triple(s2, p1, o1);
        Triple t4 = AbstractTestGraph2.triple(s2, p1, o2);
        g.add(t1);
        g.add(t2);
        g.add(t3);
        g.add(t4);
        g.clear();
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        this.returnGraph(g);
    }

    @Test
    public void count_01() {
        Graph g = this.emptyGraph();
        AbstractTestGraph2.assertEquals((long)0L, (long)g.size());
        Triple t1 = AbstractTestGraph2.triple(s1, p1, o1);
        g.add(t1);
        AbstractTestGraph2.assertEquals((long)1L, (long)g.size());
        this.returnGraph(g);
    }
}

