/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.shared.PrefixMapping;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class AbstractTestPrefixMapping2
extends BaseTest {
    static final String defaultPrefixURI = "";

    protected abstract PrefixMapping create();

    protected abstract PrefixMapping view();

    @Test
    public void prefix1() {
        PrefixMapping pmap = this.create();
    }

    @Test
    public void prefix2() {
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", "http://example/");
        AbstractTestPrefixMapping2.assertNotNull((Object)pmap.getNsPrefixURI("ex"));
    }

    @Test
    public void prefix3() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        PrefixMapping pmap2 = this.view();
        String x = pmap2.getNsPrefixURI("ex");
        AbstractTestPrefixMapping2.assertNotNull((Object)x);
        AbstractTestPrefixMapping2.assertEquals((Object)uri, (Object)x);
    }

    @Test
    public void prefix4() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        AbstractTestPrefixMapping2.assertEquals((Object)"ex", (Object)pmap.getNsURIPrefix("http://example/"));
    }

    @Test
    public void prefix5() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        AbstractTestPrefixMapping2.assertEquals((Object)(uri + "foo"), (Object)pmap.expandPrefix("ex:foo"));
    }

    @Test
    public void prefix6() {
        String uri = "http://example/";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex", uri);
        AbstractTestPrefixMapping2.assertEquals((Object)"ex:foo", (Object)pmap.qnameFor("http://example/foo"));
    }

    @Test
    public void prefix7() {
        String uri1 = "http://example/";
        String uri2 = "http://example/ns#";
        PrefixMapping pmap = this.create();
        pmap.setNsPrefix("ex1", uri1);
        pmap.setNsPrefix("ex2", uri2);
        AbstractTestPrefixMapping2.assertEquals((Object)"ex2:foo", (Object)pmap.qnameFor("http://example/ns#foo"));
    }

    @Test
    public void prefix8() {
        PrefixMapping pmap = this.create();
        String x = "scheme:i_do_not_exist";
        AbstractTestPrefixMapping2.assertEquals((Object)x, (Object)pmap.expandPrefix(x));
        AbstractTestPrefixMapping2.assertEquals((Object)x, (Object)pmap.expandPrefix(x));
    }
}

