/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class GraphsTests
extends BaseTest {
    protected static final String graph1 = "http://example/g1";
    protected static final String graph2 = "http://example/g2";
    protected static final String graph3 = "http://example/g3";
    private Dataset dataset;
    private Model calcUnion = ModelFactory.createDefaultModel();
    String queryString = "SELECT * {?s ?p ?o}";

    protected abstract Dataset createDataset();

    protected Dataset getDataset() {
        if (this.dataset == null) {
            this.dataset = this.createDataset();
            this.dataset.getDefaultModel().getGraph().add(SSE.parseTriple((String)"(<x> <p> 'Default graph')"));
            Model m1 = this.dataset.getNamedModel(graph1);
            m1.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'Graph 1')"));
            m1.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
            Model m2 = this.dataset.getNamedModel(graph2);
            m2.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'Graph 2')"));
            m2.getGraph().add(SSE.parseTriple((String)"(<x> <p> 'ZZZ')"));
            this.calcUnion.add(m1);
            this.calcUnion.add(m2);
        }
        return this.dataset;
    }

    @Test
    public void graph1() {
        Dataset ds = this.getDataset();
        int x = this.query(this.queryString, ds.getDefaultModel());
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph2() {
        Dataset ds = this.getDataset();
        int x = this.query(this.queryString, ds.getNamedModel(graph1));
        GraphsTests.assertEquals((long)2L, (long)x);
    }

    @Test
    public void graph3() {
        Dataset ds = this.getDataset();
        int x = this.query(this.queryString, ds.getNamedModel(graph3));
        GraphsTests.assertEquals((long)0L, (long)x);
    }

    @Test
    public void graph4() {
        Dataset ds = this.getDataset();
        int x = this.query(this.queryString, ds.getNamedModel(Quad.unionGraph.getURI()));
        GraphsTests.assertEquals((long)3L, (long)x);
        Model m = ds.getNamedModel(Quad.unionGraph.getURI());
        m.isIsomorphicWith(this.calcUnion);
    }

    @Test
    public void graph5() {
        Dataset ds = this.getDataset();
        int x = this.query(this.queryString, ds.getNamedModel(Quad.defaultGraphIRI.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph6() {
        Dataset ds = this.getDataset();
        int x = this.query(this.queryString, ds.getNamedModel(Quad.defaultGraphNodeGenerated.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_count1() {
        Dataset ds = this.getDataset();
        long x = this.count(ds.getDefaultModel());
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_count2() {
        Dataset ds = this.getDataset();
        long x = this.count(ds.getNamedModel(graph1));
        GraphsTests.assertEquals((long)2L, (long)x);
    }

    @Test
    public void graph_count3() {
        Dataset ds = this.getDataset();
        long x = this.count(ds.getNamedModel(graph3));
        GraphsTests.assertEquals((long)0L, (long)x);
    }

    @Test
    public void graph_count4() {
        Dataset ds = this.getDataset();
        long x = this.count(ds.getNamedModel(Quad.unionGraph.getURI()));
        GraphsTests.assertEquals((long)3L, (long)x);
    }

    @Test
    public void graph_count5() {
        Dataset ds = this.getDataset();
        long x = this.count(ds.getNamedModel(Quad.defaultGraphIRI.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_count6() {
        Dataset ds = this.getDataset();
        long x = this.count(ds.getNamedModel(Quad.defaultGraphNodeGenerated.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_count7() {
        Dataset ds = this.getDataset();
        Model m = ds.getNamedModel("http://example/no-such-graph");
        long x = m.size();
        GraphsTests.assertEquals((long)0L, (long)x);
    }

    @Test
    public void graph_api1() {
        Dataset ds = this.getDataset();
        int x = this.api(ds.getDefaultModel());
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_api2() {
        Dataset ds = this.getDataset();
        int x = this.api(ds.getNamedModel(graph1));
        GraphsTests.assertEquals((long)2L, (long)x);
    }

    @Test
    public void graph_api3() {
        Dataset ds = this.getDataset();
        int x = this.api(ds.getNamedModel(graph3));
        GraphsTests.assertEquals((long)0L, (long)x);
    }

    @Test
    public void graph_api4() {
        Dataset ds = this.getDataset();
        int x = this.api(ds.getNamedModel(Quad.unionGraph.getURI()));
        GraphsTests.assertEquals((long)3L, (long)x);
        Model m = ds.getNamedModel(Quad.unionGraph.getURI());
        m.isIsomorphicWith(this.calcUnion);
    }

    @Test
    public void graph_api5() {
        Dataset ds = this.getDataset();
        int x = this.api(ds.getNamedModel(Quad.defaultGraphIRI.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    @Test
    public void graph_api6() {
        Dataset ds = this.getDataset();
        int x = this.api(ds.getNamedModel(Quad.defaultGraphNodeGenerated.getURI()));
        GraphsTests.assertEquals((long)1L, (long)x);
    }

    private int query(String str, Model model) {
        Query q = QueryFactory.create((String)str, (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)model);){
            ResultSet rs = qexec.execSelect();
            int n = ResultSetFormatter.consume((ResultSet)rs);
            return n;
        }
    }

    private int api(Model model) {
        ExtendedIterator iter = model.getGraph().find(Node.ANY, Node.ANY, Node.ANY);
        int x = (int)Iter.count((Iterator)iter);
        return x;
    }

    private long count(Model model) {
        return model.size();
    }
}

