/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import com.hp.hpl.jena.sparql.core.DynamicDatasets;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDatasets {
    private static final String data = "INSERT DATA { <ex:default> <ex:default> <ex:default>.\nGRAPH <ex:from> { <ex:from> <ex:from> <ex:from> }\nGRAPH <ex:named> { <ex:named> <ex:named> <ex:named> }\nGRAPH <ex:other> { <ex:other> <ex:other> <ex:other> }\n}";
    private Dataset ds;
    private GraphStore gs;

    @Before
    public void setup() {
        this.ds = DatasetFactory.createMem();
        this.gs = GraphStoreFactory.create((Dataset)this.ds);
        UpdateRequest up = UpdateFactory.create((String)data);
        UpdateProcessor processor = UpdateExecutionFactory.create((UpdateRequest)up, (GraphStore)this.gs);
        processor.execute();
    }

    private void test(String query, String[] expected, int expectedCount) {
        Query q = QueryFactory.create((String)query);
        Dataset ds = DynamicDatasets.dynamicDataset((DatasetDescription)q.getDatasetDescription(), (Dataset)this.ds, (boolean)false);
        QueryExecution exec = QueryExecutionFactory.create((Query)q, (Dataset)ds);
        ResultSet results = exec.execSelect();
        ArrayList<String> found = new ArrayList<String>();
        int count = 0;
        while (results.hasNext()) {
            ++count;
            QuerySolution sln = results.next();
            found.add(sln.get("s").toString());
        }
        boolean dumped = false;
        if (expectedCount != count) {
            System.out.println(query);
            this.dump(expectedCount, count, expected, found);
            dumped = true;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
        for (String e : expected) {
            if (found.contains(e)) continue;
            if (!dumped) {
                System.out.println(query);
                this.dump(expectedCount, count, expected, found);
                dumped = true;
            }
            Assert.fail((String)("Did not find expected result " + e));
        }
    }

    private void dump(int expectedCount, int actualCount, String[] expected, List<String> actual) {
        if (expectedCount != actualCount) {
            System.out.println("Got incorrect number of results, expected " + expectedCount + " but got " + actualCount);
        } else {
            System.out.println("Did not find an expected result");
        }
        System.out.print("Expected: ");
        for (String e : expected) {
            System.out.print(e + " ");
        }
        System.out.println();
        System.out.print("Actual: ");
        for (String a : actual) {
            System.out.print(a + " ");
        }
        System.out.println();
    }

    @Test
    public void from_and_named_and_graph_uri_exists() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH <ex:named> { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void from_and_named_and_graph_uri_exists_not_in_list() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH <ex:other> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_named_and_graph_uri_missing() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_named_and_graph_var() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void from_and_named_and_graphs_var() {
        this.test("SELECT * FROM <ex:from> FROM NAMED <ex:named> FROM NAMED <ex:other> { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named", "ex:other"}, 2);
    }

    @Test
    public void from_and_graph_uri_exists() {
        this.test("SELECT * FROM <ex:from> { GRAPH <ex:named> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_graph_uri_missing() {
        this.test("SELECT * FROM <ex:from> { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from_and_graph_var() {
        this.test("SELECT * FROM <ex:from> { GRAPH ?g { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void named_graph_var() {
        this.test("SELECT * FROM NAMED <ex:named> WHERE { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void named_graphs_var() {
        this.test("SELECT * FROM NAMED <ex:named> FROM NAMED <ex:other> WHERE { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:named", "ex:other"}, 2);
    }

    @Test
    public void named_graph_uri_exists() {
        this.test("SELECT * FROM NAMED <ex:named> WHERE { GRAPH <ex:named> { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void named_graph_uri_missing() {
        this.test("SELECT * FROM NAMED <ex:named> WHERE { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void from() {
        this.test("SELECT * FROM <ex:from> WHERE { ?s ?p ?o }", new String[]{"ex:from"}, 1);
    }

    @Test
    public void graph_var() {
        this.test("SELECT * WHERE { GRAPH ?g { ?s ?p ?o } }", new String[]{"ex:from", "ex:named", "ex:other"}, 3);
    }

    @Test
    public void graph_uri_exists() {
        this.test("SELECT * WHERE { GRAPH <ex:named> { ?s ?p ?o } }", new String[]{"ex:named"}, 1);
    }

    @Test
    public void graph_uri_missing() {
        this.test("SELECT * WHERE { GRAPH <ex:missing> { ?s ?p ?o } }", new String[0], 0);
    }

    @Test
    public void no_dataset() {
        this.test("SELECT * WHERE { ?s ?p ?o }", new String[]{"ex:default"}, 1);
    }
}

