/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class EarlTestCase
extends TestCase {
    protected EarlReport report = null;
    protected String testURI = null;
    private boolean resultRecorded = false;

    protected EarlTestCase(String name, String testURI, EarlReport earl) {
        super(name);
        this.report = earl;
        this.testURI = testURI;
    }

    public void setEARL(EarlReport earl) {
        this.report = earl;
    }

    protected Query queryFromString(String qStr) {
        Query query = QueryFactory.create((String)qStr);
        return query;
    }

    protected Query queryFromTestItem(TestItem testItem) {
        if (testItem.getQueryFile() == null) {
            EarlTestCase.fail((String)"Query test file is null");
            return null;
        }
        Query query = QueryFactory.read((String)testItem.getQueryFile(), null, (Syntax)testItem.getFileSyntax());
        return query;
    }

    protected UpdateRequest updateFromString(String str) {
        return UpdateFactory.create((String)str);
    }

    protected UpdateRequest updateFromTestItem(TestItem testItem) {
        if (testItem.getQueryFile() == null) {
            EarlTestCase.fail((String)"Query test file is null");
            return null;
        }
        UpdateRequest request = UpdateFactory.read((String)testItem.getQueryFile(), (Syntax)Syntax.syntaxSPARQL_11);
        return request;
    }

    protected final void runTest() throws Throwable {
        try {
            this.runTestForReal();
            if (!this.resultRecorded) {
                this.success();
            }
        }
        catch (AssertionFailedError ex) {
            if (!this.resultRecorded) {
                this.failure();
            }
            throw ex;
        }
    }

    protected abstract void runTestForReal() throws Throwable;

    protected void setUp() throws Exception {
        this.setUpTest();
    }

    protected void tearDown() throws Exception {
        this.tearDownTest();
    }

    public void setUpTest() throws Exception {
    }

    public void tearDownTest() throws Exception {
    }

    protected void success() {
        this.note();
        if (this.report == null) {
            return;
        }
        this.report.success(this.testURI);
    }

    protected void failure() {
        this.note();
        if (this.report == null) {
            return;
        }
        this.report.failure(this.testURI);
    }

    protected void notApplicable() {
        this.note();
        if (this.report == null) {
            return;
        }
        this.report.notApplicable(this.testURI);
    }

    protected void notTested() {
        this.resultRecorded = true;
        if (this.report == null) {
            return;
        }
        this.report.notTested(this.testURI);
    }

    private void note() {
        if (this.resultRecorded) {
            throw new ARQException("Duplictaed test results: " + this.getName());
        }
        this.resultRecorded = true;
    }
}

