/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

class TextListenerOneLine
extends RunListener {
    protected Description current = null;
    protected PrintStream fWriter;

    public TextListenerOneLine(PrintStream writer) {
        this.fWriter = writer;
    }

    public void testStarted(Description description) {
        this.current = description;
        this.fWriter.println(description.getMethodName());
    }

    public void testFinished(Description description) {
        this.current = null;
    }

    public void testFailure(Failure failure) {
        if (failure.getMessage() != null && failure.getMessage().length() > 0) {
            this.fWriter.println("**** Failure: " + failure.getMessage());
        } else {
            this.fWriter.println("**** Failure");
        }
    }

    public void testIgnored(Description description) {
        this.fWriter.println("** Ignored");
    }

    public void testRunFinished(Result result) {
        this.printHeader(result.getRunTime());
        this.printFailures(result);
        this.printFooter(result);
    }

    protected void printHeader(long runTime) {
        this.fWriter.println();
        this.fWriter.println("Time: " + this.elapsedTimeAsString(runTime));
    }

    protected void printFailures(Result result) {
        List failures = result.getFailures();
        if (failures.size() == 0) {
            return;
        }
        if (result.getFailureCount() > 0) {
            this.fWriter.println();
            this.fWriter.println("===========================================");
        }
        this.printSummary(result);
        int i = 1;
        for (Failure each : failures) {
            this.printFailure(each, "" + i++);
        }
    }

    protected void printSummary(Result result) {
        int badCount = result.getFailureCount();
        int ignoredCount = result.getIgnoreCount();
        int goodCount = result.getRunCount() - badCount - ignoredCount;
        this.fWriter.print("Tests = " + result.getRunCount());
        this.fWriter.print(" : Successes = " + goodCount);
        if (ignoredCount > 0) {
            this.fWriter.print(" : Ignored = " + ignoredCount);
        }
        this.fWriter.print(" : Failures = " + badCount);
        this.fWriter.println();
        this.fWriter.println();
    }

    protected void printFailure(Failure f, String prefix) {
        System.out.print("Failure: ");
        System.out.print(prefix);
        System.out.print(" : ");
        System.out.println(f.getDescription().getDisplayName());
        System.out.println(f.getException());
        f.getException().printStackTrace(System.out);
    }

    protected void printFooter(Result result) {
        if (result.getFailureCount() > 0) {
            this.printSummary(result);
        }
    }

    protected String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }
}

