/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestUpdateOperations
extends BaseTest {
    private static final String DIR = "testing/Update";
    private Node gName = SSE.parseNode((String)"<http://example/g>");

    private GraphStore graphStore() {
        return GraphStoreFactory.create();
    }

    @Test
    public void load1() {
        GraphStore gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD <testing/Update/D.nt>");
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gs);
        TestUpdateOperations.assertEquals((long)1L, (long)gs.getDefaultGraph().size());
        TestUpdateOperations.assertFalse((boolean)gs.listGraphNodes().hasNext());
    }

    @Test
    public void load2() {
        GraphStore gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD <testing/Update/D.nt> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gs);
    }

    @Test
    public void load3() {
        GraphStore gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)"LOAD <testing/Update/D.nq>");
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gs);
        TestUpdateOperations.assertEquals((long)0L, (long)gs.getDefaultGraph().size());
        gs.containsGraph(NodeFactory.createURI((String)"http://example/"));
        TestUpdateOperations.assertEquals((long)1L, (long)gs.getGraph(this.gName).size());
    }

    @Test(expected=UpdateException.class)
    public void load4() {
        GraphStore gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD <testing/Update/D.nq> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gs);
    }

    @Test
    public void load5() {
        GraphStore gs = this.graphStore();
        UpdateRequest req = UpdateFactory.create((String)("LOAD SILENT <testing/Update/D.nq> INTO GRAPH <" + this.gName.getURI() + ">"));
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gs);
        TestUpdateOperations.assertEquals((long)0L, (long)Iter.count((Iterator)gs.find()));
    }

    @Test
    public void insert_where_01() {
        Model m = ModelFactory.createDefaultModel();
        Resource anon = m.createResource();
        anon.addProperty(RDF.type, (RDFNode)OWL.Thing);
        TestUpdateOperations.assertEquals((long)1L, (long)m.size());
        GraphStore gs = GraphStoreFactory.create((Model)m);
        UpdateRequest req = UpdateFactory.create((String)"INSERT { ?s ?p ?o } WHERE { ?o ?p ?s }");
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gs);
        TestUpdateOperations.assertEquals((long)2L, (long)m.size());
        TestUpdateOperations.assertEquals((long)1L, (long)m.listStatements(anon, null, (RDFNode)null).toList().size());
        TestUpdateOperations.assertEquals((long)1L, (long)m.listStatements(null, null, (RDFNode)anon).toList().size());
    }
}

