/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.transaction;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.JenaTransactionException;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class AbstractTestTransaction
extends BaseTest {
    protected abstract Dataset create();

    @Test
    public void transaction_err_00() {
        Dataset ds = this.create();
        AbstractTestTransaction.assertTrue((boolean)ds.supportsTransactions());
    }

    @Test
    public void transaction_01() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.READ);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.end();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_02() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.WRITE);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_03() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.WRITE);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_04() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.WRITE);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
        ds.end();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_05() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.WRITE);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
        ds.end();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_06() {
        Dataset ds = this.create();
        ds.begin(ReadWrite.WRITE);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
        ds.begin(ReadWrite.WRITE);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.abort();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
    }

    @Test
    public void transaction_07() {
        Dataset ds = this.create();
        this.read1(ds);
        this.read1(ds);
    }

    @Test
    public void transaction_08() {
        Dataset ds = this.create();
        this.read2(ds);
        this.read2(ds);
    }

    @Test
    public void transaction_09() {
        Dataset ds = this.create();
        this.write(ds);
        this.write(ds);
    }

    @Test
    public void transaction_10() {
        Dataset ds = this.create();
        this.write(ds);
        this.read2(ds);
        this.read2(ds);
        this.write(ds);
        this.read2(ds);
    }

    @Test
    public void transaction_err_01() {
        this.testBeginBegin(ReadWrite.WRITE, ReadWrite.WRITE);
    }

    @Test
    public void transaction_err_02() {
        this.testBeginBegin(ReadWrite.WRITE, ReadWrite.READ);
    }

    @Test
    public void transaction_err_03() {
        this.testBeginBegin(ReadWrite.READ, ReadWrite.READ);
    }

    @Test
    public void transaction_err_04() {
        this.testBeginBegin(ReadWrite.READ, ReadWrite.WRITE);
    }

    @Test
    public void transaction_err_05() {
        this.testCommitCommit(ReadWrite.READ);
    }

    @Test
    public void transaction_err_06() {
        this.testCommitCommit(ReadWrite.WRITE);
    }

    @Test
    public void transaction_err_07() {
        this.testCommitAbort(ReadWrite.READ);
    }

    @Test
    public void transaction_err_08() {
        this.testCommitAbort(ReadWrite.WRITE);
    }

    @Test
    public void transaction_err_09() {
        this.testAbortAbort(ReadWrite.READ);
    }

    @Test
    public void transaction_err_10() {
        this.testAbortAbort(ReadWrite.WRITE);
    }

    @Test
    public void transaction_err_11() {
        this.testAbortCommit(ReadWrite.READ);
    }

    @Test
    public void transaction_err_12() {
        this.testAbortCommit(ReadWrite.WRITE);
    }

    private void read1(Dataset ds) {
        ds.begin(ReadWrite.READ);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
        ds.end();
    }

    private void read2(Dataset ds) {
        ds.begin(ReadWrite.READ);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.end();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
    }

    private void write(Dataset ds) {
        ds.begin(ReadWrite.WRITE);
        AbstractTestTransaction.assertTrue((boolean)ds.isInTransaction());
        ds.commit();
        AbstractTestTransaction.assertFalse((boolean)ds.isInTransaction());
        ds.end();
    }

    private void testBeginBegin(ReadWrite mode1, ReadWrite mode2) {
        Dataset ds = this.create();
        ds.begin(mode1);
        try {
            ds.begin(mode2);
            AbstractTestTransaction.fail((String)("Expected transaction exception - begin-begin (" + mode1 + ", " + mode2 + ")"));
        }
        catch (JenaTransactionException ex) {
            ds.end();
        }
    }

    private void testCommitCommit(ReadWrite mode) {
        Dataset ds = this.create();
        ds.begin(mode);
        ds.commit();
        try {
            ds.commit();
            AbstractTestTransaction.fail((String)("Expected transaction exception - commit-commit(" + mode + ")"));
        }
        catch (JenaTransactionException ex) {
            ds.end();
        }
    }

    private void testCommitAbort(ReadWrite mode) {
        Dataset ds = this.create();
        ds.begin(mode);
        ds.commit();
        try {
            ds.abort();
            AbstractTestTransaction.fail((String)("Expected transaction exception - commit-abort(" + mode + ")"));
        }
        catch (JenaTransactionException ex) {
            ds.end();
        }
    }

    private void testAbortAbort(ReadWrite mode) {
        Dataset ds = this.create();
        ds.begin(mode);
        ds.abort();
        try {
            ds.abort();
            AbstractTestTransaction.fail((String)("Expected transaction exception - abort-abort(" + mode + ")"));
        }
        catch (JenaTransactionException ex) {
            ds.end();
        }
    }

    private void testAbortCommit(ReadWrite mode) {
        Dataset ds = this.create();
        ds.begin(mode);
        ds.abort();
        try {
            ds.commit();
            AbstractTestTransaction.fail((String)("Expected transaction exception - abort-commit(" + mode + ")"));
        }
        catch (JenaTransactionException ex) {
            ds.end();
        }
    }
}

