/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestFmtUtils {
    public static final String aUri = "http://www.zz.org/xx#";

    @Test
    public void stringForTripleEncoding() {
        Assert.assertEquals((Object)"<n1> <n2> \"l3\"", (Object)FmtUtils.stringForTriple((Triple)this.getTriple()));
    }

    @Test
    public void stringForTriple_WithPrefixMapping() {
        Assert.assertEquals((Object)"zz:abs <n2> \"l3\"", (Object)FmtUtils.stringForTriple((Triple)this.getPrefixedTriple(), (PrefixMapping)this.getPrefixMapping()));
    }

    @Test
    public void stringForQuadEncoding() {
        Node n1 = NodeFactory.createURI((String)"q1");
        Quad quad = new Quad(n1, this.getTriple());
        Assert.assertEquals((Object)"<q1> <n1> <n2> \"l3\"", (Object)FmtUtils.stringForQuad((Quad)quad));
    }

    @Test
    public void stringForQuad_WithPrefixMapping() {
        Node n1 = NodeFactory.createURI((String)"q1");
        Quad quad = new Quad(n1, this.getPrefixedTriple());
        Assert.assertEquals((Object)"<q1> zz:abs <n2> \"l3\"", (Object)FmtUtils.stringForQuad((Quad)quad, (PrefixMapping)this.getPrefixMapping()));
    }

    @Test
    public void formatPattern_2_triples() {
        BasicPattern basicPattern = new BasicPattern();
        basicPattern.add(this.getTriple());
        basicPattern.add(this.getTriple2());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (IndentedWriter iw = new IndentedWriter((OutputStream)os);){
            SerializationContext sc = new SerializationContext();
            FmtUtils.formatPattern((IndentedWriter)iw, (BasicPattern)basicPattern, (SerializationContext)sc);
        }
        Assert.assertEquals((Object)"<n1> <n2> \"l3\" .\n<nb1> <nb2> \"lb3\" .", (Object)new String(os.toByteArray()));
    }

    @Test
    public void stringForObject_misc_versions() throws Exception {
        Assert.assertEquals((Object)"<<null>>", (Object)FmtUtils.stringForObject(null));
        Assert.assertEquals((Object)"<n1>", (Object)FmtUtils.stringForObject((Object)new LiteralImpl(this.aNode(), null)));
        Assert.assertEquals((Object)"<nzz1>", (Object)FmtUtils.stringForObject((Object)new ResourceImpl(NodeFactory.createURI((String)"nzz1"), null)));
        Assert.assertEquals((Object)"abc", (Object)FmtUtils.stringForObject((Object)"abc"));
    }

    @Test
    public void stringForRDFNode_literal() {
        Assert.assertEquals((Object)"<n1>", (Object)FmtUtils.stringForRDFNode((RDFNode)new LiteralImpl(this.aNode(), null)));
    }

    @Test
    public void stringLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createUncachedLiteral((Object)"abc", (String)"no", (RDFDatatype)new XSDDatatype("string"));
        Assert.assertEquals((Object)"\"abc\"@no", (Object)FmtUtils.stringForLiteral((Node_Literal)nl, (SerializationContext)this.getContext()));
    }

    @Test
    public void integerLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createUncachedLiteral((Object)"2", (RDFDatatype)new XSDDatatype("int"));
        Assert.assertEquals((Object)"\"2\"^^<http://www.w3.org/2001/XMLSchema#int>", (Object)FmtUtils.stringForLiteral((Node_Literal)nl, (SerializationContext)this.getContext()));
    }

    @Test
    public void doubleLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createUncachedLiteral((Object)"2.1e2", (RDFDatatype)new XSDDatatype("double"));
        Assert.assertEquals((Object)"2.1e2", (Object)FmtUtils.stringForLiteral((Node_Literal)nl, (SerializationContext)this.getContext()));
    }

    @Test
    public void decimalLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createUncachedLiteral((Object)"2.4", (RDFDatatype)new XSDDatatype("decimal"));
        Assert.assertEquals((Object)"2.4", (Object)FmtUtils.stringForLiteral((Node_Literal)nl, (SerializationContext)this.getContext()));
    }

    @Test
    public void booleanLiteral() throws Exception {
        Node_Literal nl = (Node_Literal)NodeFactory.createUncachedLiteral((Object)"false", (RDFDatatype)new XSDDatatype("boolean"));
        Assert.assertEquals((Object)"false", (Object)FmtUtils.stringForLiteral((Node_Literal)nl, (SerializationContext)this.getContext()));
    }

    @Test
    public void stringForRDFNode_resource() throws Exception {
        ResourceImpl rdfNod = new ResourceImpl(this.aUriRemappableNode(), null);
        Assert.assertEquals((Object)"zz:abs", (Object)FmtUtils.stringForRDFNode((RDFNode)rdfNod, (SerializationContext)this.getContext()));
    }

    @Test
    public void anonNode1() {
        FmtUtils.resetBNodeLabels();
        Assert.assertEquals((Object)"_:b0", (Object)FmtUtils.stringForNode((Node)NodeFactory.createAnon()));
    }

    @Test
    public void anonNode2() {
        FmtUtils.resetBNodeLabels();
        Assert.assertEquals((Object)"_:b0", (Object)FmtUtils.stringForNode((Node)NodeFactory.createAnon()));
        Assert.assertEquals((Object)"_:b1", (Object)FmtUtils.stringForNode((Node)NodeFactory.createAnon()));
        Assert.assertEquals((Object)"_:b2", (Object)FmtUtils.stringForNode((Node)NodeFactory.createAnon()));
    }

    @Test
    public void variableNode() {
        Assert.assertEquals((Object)"?tt", (Object)FmtUtils.stringForNode((Node)NodeFactory.createVariable((String)"tt")));
    }

    @Test
    public void anyNode() {
        Assert.assertEquals((Object)"ANY", (Object)FmtUtils.stringForNode((Node)Node.ANY));
    }

    @Test
    public void testStringForURI() throws Exception {
        String s = FmtUtils.stringForURI((String)"zz:\u00fc_fe-zz");
        Assert.assertEquals((Object)"<zz:\u00fc_fe-zz>", (Object)s);
    }

    @Test
    public void testStringEsc() {
        Assert.assertEquals((Object)"\\\\\\r\\n", (Object)FmtUtils.stringEsc((String)"\\\r\n"));
    }

    @Test
    public void stringForString() {
        Assert.assertEquals((Object)"\"a\\rbt\"", (Object)FmtUtils.stringForString((String)"a\rbt"));
    }

    @Test
    public void testFormatBGP_1() {
        IndentedLineBuffer b = new IndentedLineBuffer();
        BasicPattern bgp = SSE.parseBGP((String)"(prefix ((zz: <http://www.zz.org/xx#>)) (bgp (zz:s zz:p zz:o)))");
        FmtUtils.formatPattern((IndentedWriter)b, (BasicPattern)bgp, (SerializationContext)this.getContext());
        Assert.assertEquals((Object)"zz:s zz:p zz:o .", (Object)b.toString());
    }

    @Test
    public void testFormatBGP_2() {
        IndentedLineBuffer b = new IndentedLineBuffer();
        BasicPattern bgp = SSE.parseBGP((String)"(prefix ((zz: <http://www.zz.org/xx#>)) (bgp (zz:s zz:p zz:o) (zz:s zz:p 123) ))");
        FmtUtils.formatPattern((IndentedWriter)b, (BasicPattern)bgp, (SerializationContext)this.getContext());
        Assert.assertEquals((Object)"zz:s zz:p zz:o .\nzz:s zz:p 123 .", (Object)b.toString());
    }

    private Triple getTriple() {
        Node n1 = this.aNode();
        Node n2 = NodeFactory.createURI((String)"n2");
        Node l3 = NodeFactory.createLiteral((String)"l3");
        return new Triple(n1, n2, l3);
    }

    private Node aNode() {
        return NodeFactory.createURI((String)"n1");
    }

    private Triple getTriple2() {
        Node n1 = NodeFactory.createURI((String)"nb1");
        Node n2 = NodeFactory.createURI((String)"nb2");
        Node l3 = NodeFactory.createLiteral((String)"lb3");
        return new Triple(n1, n2, l3);
    }

    private Triple getPrefixedTriple() {
        Node n1 = this.aUriRemappableNode();
        Node n2 = NodeFactory.createURI((String)"n2");
        Node l3 = NodeFactory.createLiteral((String)"l3");
        return new Triple(n1, n2, l3);
    }

    private Node aUriRemappableNode() {
        return NodeFactory.createURI((String)"http://www.zz.org/xx#abs");
    }

    private PrefixMapping getPrefixMapping() {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        pmap.setNsPrefix("zz", aUri);
        return pmap;
    }

    private SerializationContext getContext() {
        return new SerializationContext(this.getPrefixMapping());
    }
}

