/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import org.apache.jena.atlas.io.PeekInputStream;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class AbstractTestPeekInputStream
extends BaseTest {
    static int INIT_LINE = 1;
    static int INIT_COL = 1;

    abstract PeekInputStream make(String var1, int var2);

    @Test
    public void read0() {
        AbstractTestPeekInputStream.assertEquals((String)"Init line", (long)1L, (long)INIT_LINE);
        AbstractTestPeekInputStream.assertEquals((String)"Init col", (long)1L, (long)INIT_COL);
    }

    @Test
    public void read1() {
        PeekInputStream in = this.make("");
        this.checkLineCol(in, INIT_LINE, INIT_COL);
        int x = in.peekByte();
        AbstractTestPeekInputStream.assertEquals((long)-1L, (long)x);
        x = in.readByte();
        AbstractTestPeekInputStream.assertEquals((long)-1L, (long)x);
        x = in.readByte();
        AbstractTestPeekInputStream.assertEquals((long)-1L, (long)x);
    }

    @Test
    public void read2() {
        PeekInputStream in = this.make("a");
        this.checkLineCol(in, INIT_LINE, INIT_COL);
        int x = in.peekByte();
        AbstractTestPeekInputStream.assertEquals((long)97L, (long)x);
        this.checkLineCol(in, INIT_LINE, INIT_COL);
        x = in.readByte();
        this.checkLineCol(in, INIT_LINE, INIT_COL + 1);
        AbstractTestPeekInputStream.assertEquals((long)97L, (long)x);
        x = in.peekByte();
        AbstractTestPeekInputStream.assertEquals((long)-1L, (long)x);
        x = in.readByte();
        AbstractTestPeekInputStream.assertEquals((long)-1L, (long)x);
    }

    @Test
    public void read3() {
        String c = "abcde";
        PeekInputStream in = this.make(c);
        for (int i = 0; i < c.length(); ++i) {
            this.checkLineCol(in, INIT_LINE, i + INIT_COL);
            long z = in.getPosition();
            AbstractTestPeekInputStream.assertEquals((long)i, (long)in.getPosition());
            AbstractTestPeekInputStream.assertEquals((long)c.charAt(i), (long)in.readByte());
        }
        AbstractTestPeekInputStream.assertTrue((boolean)in.eof());
    }

    @Test
    public void read4() {
        this.position("abcde");
    }

    @Test
    public void read5() {
        this.position("abc\nde");
    }

    @Test
    public void read6() {
        this.position("abc\nde\n");
    }

    @Test
    public void read7() {
        this.position("");
    }

    @Test
    public void read8() {
        this.position("x");
    }

    @Test
    public void read9() {
        PeekInputStream in = this.make("a\nb\n");
        this.checkLineCol(in, INIT_LINE, INIT_COL);
        int x = in.peekByte();
        AbstractTestPeekInputStream.assertEquals((long)97L, (long)x);
        this.checkLineCol(in, INIT_LINE, INIT_COL);
        x = in.readByte();
        AbstractTestPeekInputStream.assertEquals((long)97L, (long)x);
        this.checkLineCol(in, INIT_LINE, INIT_COL + 1);
        x = in.readByte();
        AbstractTestPeekInputStream.assertEquals((long)10L, (long)x);
        this.checkLineCol(in, INIT_LINE + 1, INIT_COL);
    }

    @Test
    public void unread1() {
        PeekInputStream in = this.make("abc");
        AbstractTestPeekInputStream.assertEquals((long)97L, (long)in.peekByte());
        in.pushbackByte(90);
        AbstractTestPeekInputStream.assertEquals((long)90L, (long)in.peekByte());
        this.contains(in, "Zabc");
    }

    @Test
    public void unread2() {
        PeekInputStream in = this.make("abc");
        this.checkLineCol(in, INIT_LINE, INIT_COL);
        int ch = in.readByte();
        this.checkLineCol(in, INIT_LINE, INIT_COL + 1);
        AbstractTestPeekInputStream.assertEquals((long)98L, (long)in.peekByte());
        this.checkLineCol(in, INIT_LINE, INIT_COL + 1);
        in.pushbackByte(97);
        this.checkLineCol(in, INIT_LINE, INIT_COL + 1);
        this.contains(in, "abc");
    }

    @Test
    public void unread3() {
        PeekInputStream in = this.make("");
        int ch = in.readByte();
        AbstractTestPeekInputStream.assertEquals((long)-1L, (long)in.peekByte());
        in.pushbackByte(97);
        this.contains(in, "a");
    }

    @Test
    public void unread4() {
        PeekInputStream in = this.make("");
        int ch = in.readByte();
        AbstractTestPeekInputStream.assertEquals((long)-1L, (long)in.peekByte());
        in.pushbackByte(48);
        in.pushbackByte(49);
        in.pushbackByte(50);
        in.pushbackByte(51);
        this.contains(in, "3210");
    }

    @Test
    public void unread5() {
        PeekInputStream in = this.make("");
        long lineNum = in.getLineNum();
        long colNum = in.getColNum();
        this.checkLineCol(in, lineNum, colNum);
        in.pushbackByte(48);
        this.checkLineCol(in, lineNum, colNum);
        in.pushbackByte(49);
        this.checkLineCol(in, lineNum, colNum);
        AbstractTestPeekInputStream.assertEquals((long)49L, (long)in.readByte());
        this.checkLineCol(in, lineNum, colNum);
        in.pushbackByte(50);
        in.pushbackByte(51);
        this.checkLineCol(in, lineNum, colNum);
        AbstractTestPeekInputStream.assertEquals((long)51L, (long)in.peekByte());
        this.contains(in, "320");
    }

    private void checkLineCol(PeekInputStream in, long lineNum, long colNum) {
        AbstractTestPeekInputStream.assertEquals((String)"Line", (long)lineNum, (long)in.getLineNum());
        AbstractTestPeekInputStream.assertEquals((String)"Column", (long)colNum, (long)in.getColNum());
    }

    private void position(String contents) {
        PeekInputStream in = this.make(contents);
        int line = INIT_LINE;
        int col = INIT_COL;
        this.checkLineCol(in, line, col);
        AbstractTestPeekInputStream.assertEquals((long)0L, (long)in.getPosition());
        for (int i = 0; i < contents.length(); ++i) {
            int x = in.readByte();
            if (x != -1) {
                if (x == 10) {
                    ++line;
                    col = INIT_COL;
                } else {
                    ++col;
                }
            }
            AbstractTestPeekInputStream.assertEquals((long)contents.charAt(i), (long)x);
            AbstractTestPeekInputStream.assertEquals((long)(i + 1), (long)in.getPosition());
            this.checkLineCol(in, line, col);
        }
        AbstractTestPeekInputStream.assertTrue((boolean)in.eof());
    }

    private void contains(PeekInputStream in, String contents) {
        for (int i = 0; i < contents.length(); ++i) {
            int x = in.readByte();
            AbstractTestPeekInputStream.assertEquals((String)("\"" + contents + "\" -- Index " + i + " Expected:'" + contents.charAt(i) + "' Got: '" + (char)x + "'"), (long)contents.charAt(i), (long)x);
        }
        AbstractTestPeekInputStream.assertTrue((boolean)in.eof());
    }

    private PeekInputStream make(String contents) {
        return this.make(contents, 2);
    }
}

