/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public abstract class AbstractTestPeekReader
extends BaseTest {
    static int INIT_LINE = 1;
    static int INIT_COL = 1;

    abstract PeekReader make(String var1, int var2);

    @Test
    public void read0() {
        AbstractTestPeekReader.assertEquals((String)"Init line", (long)1L, (long)INIT_LINE);
        AbstractTestPeekReader.assertEquals((String)"Init col", (long)1L, (long)INIT_COL);
    }

    @Test
    public void read1() {
        PeekReader r = this.make("");
        this.checkLineCol(r, INIT_LINE, INIT_COL);
        int x = r.peekChar();
        AbstractTestPeekReader.assertEquals((long)-1L, (long)x);
        x = r.readChar();
        AbstractTestPeekReader.assertEquals((long)-1L, (long)x);
        x = r.readChar();
        AbstractTestPeekReader.assertEquals((long)-1L, (long)x);
    }

    @Test
    public void read2() {
        PeekReader r = this.make("a");
        this.checkLineCol(r, INIT_LINE, INIT_COL);
        int x = r.peekChar();
        AbstractTestPeekReader.assertEquals((long)97L, (long)x);
        this.checkLineCol(r, INIT_LINE, INIT_COL);
        x = r.readChar();
        this.checkLineCol(r, INIT_LINE, INIT_COL + 1);
        AbstractTestPeekReader.assertEquals((long)97L, (long)x);
        x = r.peekChar();
        AbstractTestPeekReader.assertEquals((long)-1L, (long)x);
        x = r.readChar();
        AbstractTestPeekReader.assertEquals((long)-1L, (long)x);
    }

    @Test
    public void read3() {
        String c = "abcde";
        PeekReader r = this.make(c);
        for (int i = 0; i < c.length(); ++i) {
            this.checkLineCol(r, INIT_LINE, i + INIT_COL);
            long z = r.getPosition();
            AbstractTestPeekReader.assertEquals((long)i, (long)r.getPosition());
            AbstractTestPeekReader.assertEquals((long)c.charAt(i), (long)r.readChar());
        }
        AbstractTestPeekReader.assertTrue((boolean)r.eof());
    }

    @Test
    public void read4() {
        this.position("abcde");
    }

    @Test
    public void read5() {
        this.position("abc\nde");
    }

    @Test
    public void read6() {
        this.position("abc\nde\n");
    }

    @Test
    public void read7() {
        this.position("");
    }

    @Test
    public void read8() {
        this.position("x");
    }

    @Test
    public void read9() {
        PeekReader r = this.make("a\nb\n");
        this.checkLineCol(r, INIT_LINE, INIT_COL);
        int x = r.peekChar();
        AbstractTestPeekReader.assertEquals((long)97L, (long)x);
        this.checkLineCol(r, INIT_LINE, INIT_COL);
        x = r.readChar();
        AbstractTestPeekReader.assertEquals((long)97L, (long)x);
        this.checkLineCol(r, INIT_LINE, INIT_COL + 1);
        x = r.readChar();
        AbstractTestPeekReader.assertEquals((long)10L, (long)x);
        this.checkLineCol(r, INIT_LINE + 1, INIT_COL);
    }

    @Test
    public void unread1() {
        PeekReader r = this.make("abc");
        AbstractTestPeekReader.assertEquals((long)97L, (long)r.peekChar());
        r.pushbackChar(90);
        AbstractTestPeekReader.assertEquals((long)90L, (long)r.peekChar());
        this.contains(r, "Zabc");
    }

    @Test
    public void unread2() {
        PeekReader r = this.make("abc");
        this.checkLineCol(r, INIT_LINE, INIT_COL);
        int ch = r.readChar();
        this.checkLineCol(r, INIT_LINE, INIT_COL + 1);
        AbstractTestPeekReader.assertEquals((long)98L, (long)r.peekChar());
        this.checkLineCol(r, INIT_LINE, INIT_COL + 1);
        r.pushbackChar(97);
        this.checkLineCol(r, INIT_LINE, INIT_COL + 1);
        this.contains(r, "abc");
    }

    @Test
    public void unread3() {
        PeekReader r = this.make("");
        int ch = r.readChar();
        AbstractTestPeekReader.assertEquals((long)-1L, (long)r.peekChar());
        r.pushbackChar(97);
        this.contains(r, "a");
    }

    @Test
    public void unread4() {
        PeekReader r = this.make("");
        int ch = r.readChar();
        AbstractTestPeekReader.assertEquals((long)-1L, (long)r.peekChar());
        r.pushbackChar(48);
        r.pushbackChar(49);
        r.pushbackChar(50);
        r.pushbackChar(51);
        this.contains(r, "3210");
    }

    @Test
    public void unread5() {
        PeekReader r = this.make("");
        long lineNum = r.getLineNum();
        long colNum = r.getColNum();
        this.checkLineCol(r, lineNum, colNum);
        r.pushbackChar(48);
        this.checkLineCol(r, lineNum, colNum);
        r.pushbackChar(49);
        this.checkLineCol(r, lineNum, colNum);
        AbstractTestPeekReader.assertEquals((long)49L, (long)r.readChar());
        this.checkLineCol(r, lineNum, colNum);
        r.pushbackChar(50);
        r.pushbackChar(51);
        this.checkLineCol(r, lineNum, colNum);
        AbstractTestPeekReader.assertEquals((long)51L, (long)r.peekChar());
        this.contains(r, "320");
    }

    private void checkLineCol(PeekReader r, long lineNum, long colNum) {
        AbstractTestPeekReader.assertEquals((String)"Line", (long)lineNum, (long)r.getLineNum());
        AbstractTestPeekReader.assertEquals((String)"Column", (long)colNum, (long)r.getColNum());
    }

    private void position(String contents) {
        PeekReader r = this.make(contents);
        int line = INIT_LINE;
        int col = INIT_COL;
        this.checkLineCol(r, line, col);
        AbstractTestPeekReader.assertEquals((long)0L, (long)r.getPosition());
        for (int i = 0; i < contents.length(); ++i) {
            int x = r.readChar();
            if (x != -1) {
                if (x == 10) {
                    ++line;
                    col = INIT_COL;
                } else {
                    ++col;
                }
            }
            AbstractTestPeekReader.assertEquals((long)contents.charAt(i), (long)x);
            AbstractTestPeekReader.assertEquals((long)(i + 1), (long)r.getPosition());
            this.checkLineCol(r, line, col);
        }
        AbstractTestPeekReader.assertTrue((boolean)r.eof());
    }

    private void contains(PeekReader r, String contents) {
        for (int i = 0; i < contents.length(); ++i) {
            int x = r.readChar();
            AbstractTestPeekReader.assertEquals((String)("\"" + contents + "\" -- Index " + i + " Expected:'" + contents.charAt(i) + "' Got: '" + (char)x + "'"), (long)contents.charAt(i), (long)x);
        }
        AbstractTestPeekReader.assertTrue((boolean)r.eof());
    }

    private PeekReader make(String contents) {
        return this.make(contents, 2);
    }
}

