/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.IteratorArray;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestIteratorArray
extends BaseTest {
    IteratorArray<String> create(String ... a) {
        return IteratorArray.create((Object[])a);
    }

    IteratorArray<String> create(int start, int finish, String ... a) {
        return IteratorArray.create((Object[])a, (int)start, (int)finish);
    }

    @Test
    public void arrayIterator_1() {
        IteratorArray<String> iter = this.create(new String[0]);
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_2() {
        IteratorArray<String> iter = this.create("a");
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_3() {
        IteratorArray<String> iter = this.create("a", "b", "c");
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"b", iter.next());
        TestIteratorArray.assertTrue((boolean)iter.hasNext());
        TestIteratorArray.assertEquals((Object)"c", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_4() {
        IteratorArray<String> iter = this.create("a");
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        try {
            iter.next();
            TestIteratorArray.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void arrayIterator_5() {
        IteratorArray<String> iter = this.create(0, 1, "a", "b", "c");
        TestIteratorArray.assertEquals((Object)"a", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_6() {
        IteratorArray<String> iter = this.create(1, 3, "a", "b", "c", "d");
        TestIteratorArray.assertEquals((Object)"b", iter.next());
        TestIteratorArray.assertEquals((Object)"c", iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void arrayIterator_7() {
        IteratorArray<String> iter = this.create(1, 3, "a", "b", "c", "d");
        TestIteratorArray.assertEquals((Object)"b", (Object)iter.current());
        TestIteratorArray.assertEquals((Object)"b", (Object)iter.current());
        TestIteratorArray.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorArray.assertEquals((Object)"c", (Object)iter.current());
        TestIteratorArray.assertEquals((Object)"c", (Object)iter.next());
        TestIteratorArray.assertFalse((boolean)iter.hasNext());
    }
}

