/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIteratorSlotted
extends BaseTest {
    private IterFactory factory;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> implementations() {
        IterFactory factory1 = new IterFactory(){

            @Override
            public IteratorSlotted<String> create(String ... array) {
                return new IterStr1(array);
            }
        };
        IterFactory factory2 = new IterFactory(){

            @Override
            public IteratorSlotted<String> create(String ... array) {
                return new IterStr2(array);
            }
        };
        return Arrays.asList({"hasMore accurate", factory1}, {"hasMore always true", factory2});
    }

    public TestIteratorSlotted(String name, IterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void iter_01() {
        IteratorSlotted<String> iter = this.factory.create(new String[0]);
        TestIteratorSlotted.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void iter_02() {
        IteratorSlotted<String> iter = this.factory.create("A");
        TestIteratorSlotted.assertTrue((boolean)iter.hasNext());
        TestIteratorSlotted.assertEquals((Object)"A", (Object)iter.peek());
        TestIteratorSlotted.assertEquals((Object)"A", (Object)iter.peek());
        TestIteratorSlotted.assertEquals((Object)"A", (Object)iter.next());
        TestIteratorSlotted.assertFalse((boolean)iter.hasNext());
        TestIteratorSlotted.assertNull((Object)iter.peek());
    }

    @Test
    public void iter_03() {
        IteratorSlotted<String> iter = this.factory.create("A", "B");
        TestIteratorSlotted.assertTrue((boolean)iter.hasNext());
        TestIteratorSlotted.assertEquals((Object)"A", (Object)iter.peek());
        TestIteratorSlotted.assertEquals((Object)"A", (Object)iter.next());
        TestIteratorSlotted.assertEquals((Object)"B", (Object)iter.peek());
        TestIteratorSlotted.assertEquals((Object)"B", (Object)iter.next());
        TestIteratorSlotted.assertFalse((boolean)iter.hasNext());
    }

    static interface IterFactory {
        public IteratorSlotted<String> create(String ... var1);
    }

    static class IterStr2
    extends IteratorSlotted<String> {
        private List<String> array;
        private Iterator<String> iter;

        IterStr2(String ... array) {
            this.array = Arrays.asList(array);
            this.iter = this.array.iterator();
        }

        protected String moveToNext() {
            if (!this.iter.hasNext()) {
                return null;
            }
            return this.iter.next();
        }

        protected boolean hasMore() {
            return true;
        }
    }

    static class IterStr1
    extends IteratorSlotted<String> {
        private List<String> array;
        private Iterator<String> iter;

        IterStr1(String ... array) {
            this.array = Arrays.asList(array);
            this.iter = this.array.iterator();
        }

        protected String moveToNext() {
            return this.iter.next();
        }

        protected boolean hasMore() {
            return this.iter.hasNext();
        }
    }
}

