/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonException;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.junit.BaseTest;
import org.junit.Test;

public class TestJsonBuilder
extends BaseTest {
    @Test
    public void jsonBuild01() {
        JsonValue x = JSON.parseAny((String)"{ }");
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("A");
        builder.finishObject("A");
        JsonValue v = builder.build();
        TestJsonBuilder.assertEquals((Object)x, (Object)v);
    }

    @Test
    public void jsonBuild02() {
        JsonValue x = JSON.parseAny((String)"{ a: 'A', b:'B'}");
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("Obj1");
        builder.key("a").value("A");
        builder.key("b").value("B");
        builder.finishObject("Obj1");
        JsonValue v = builder.build();
        TestJsonBuilder.assertEquals((Object)x, (Object)v);
    }

    @Test
    public void jsonBuild03() {
        JsonValue x = JSON.parseAny((String)"[ ]");
        JsonBuilder builder = new JsonBuilder();
        builder.startArray();
        builder.finishArray();
        JsonValue v = builder.build();
        TestJsonBuilder.assertEquals((Object)x, (Object)v);
    }

    @Test
    public void jsonBuild04() {
        JsonValue x = JSON.parseAny((String)"{ a: [1], b:'B'}");
        JsonBuilder builder = new JsonBuilder();
        builder.startObject();
        builder.key("a").startArray().value(1L).finishArray();
        builder.key("b").value("B");
        builder.finishObject();
        JsonValue v = builder.build();
        TestJsonBuilder.assertEquals((Object)x, (Object)v);
    }

    @Test
    public void jsonBuild05() {
        JsonValue x = JSON.parseAny((String)"[ { a: 'B'} , 56]");
        JsonBuilder builder = new JsonBuilder();
        builder.startArray();
        builder.startObject().key("a").value("B").finishObject();
        builder.value(56L);
        builder.finishArray();
        JsonValue v = builder.build();
        TestJsonBuilder.assertEquals((Object)x, (Object)v);
    }

    @Test(expected=JsonException.class)
    public void jsonBuildErr00() {
        JsonBuilder builder = new JsonBuilder();
        JsonValue v = builder.build();
    }

    @Test(expected=JsonException.class)
    public void jsonBuildErr01() {
        JsonBuilder builder = new JsonBuilder();
        builder.startArray();
        builder.finishObject();
    }

    @Test(expected=JsonException.class)
    public void jsonBuildErr02() {
        JsonBuilder builder = new JsonBuilder();
        builder.startObject();
        builder.finishArray();
    }

    @Test(expected=JsonException.class)
    public void jsonBuildErr03() {
        JsonBuilder builder = new JsonBuilder();
        builder.startObject("A");
        builder.finishObject("B");
    }
}

