/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.junit;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.junit.Assert;

public class BaseTest
extends Assert {
    private static Deque<ErrorHandler> errorHandlers = new ArrayDeque<ErrorHandler>();

    public static void setTestLogging(ErrorHandler errorhandler) {
        errorHandlers.push(ErrorHandlerFactory.getDefaultErrorHandler());
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)errorhandler);
    }

    public static void setTestLogging() {
        BaseTest.setTestLogging(ErrorHandlerFactory.errorHandlerNoLogging);
    }

    public static void unsetTestLogging() {
        if (errorHandlers.size() == 0) {
            Log.warn(BaseTest.class, (String)"ErrorHandler not set for testing");
            ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerStd);
            return;
        }
        ErrorHandler errHandler = errorHandlers.pop();
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)errHandler);
    }

    public static void assertEqualsIgnoreCase(String a, String b) {
        a = a.toLowerCase(Locale.ROOT);
        b = b.toLowerCase(Locale.ROOT);
        BaseTest.assertEquals((Object)a, (Object)b);
    }

    public static void assertEqualsIgnoreCase(String msg, String a, String b) {
        a = a.toLowerCase(Locale.ROOT);
        b = b.toLowerCase(Locale.ROOT);
        BaseTest.assertEquals((String)msg, (Object)a, (Object)b);
    }

    public static <T> void assertEqualsUnordered(List<T> list1, List<T> list2) {
        if (list1.size() != list2.size()) {
            BaseTest.fail((String)("Expected: " + list1 + " : Actual: " + list2));
        }
        ArrayList<T> list2a = new ArrayList<T>(list2);
        for (T elt : list1) {
            list2a.remove(elt);
        }
        if (list2a.size() != 0) {
            BaseTest.fail((String)("Expected: " + list1 + " : Actual: " + list2));
        }
    }
}

