/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.AlarmClock;
import org.apache.jena.atlas.lib.Lib;
import org.junit.Test;

public class TestAlarmClock
extends BaseTest {
    AtomicInteger count = new AtomicInteger(0);
    Runnable callback = new Runnable(){

        @Override
        public void run() {
            TestAlarmClock.this.count.getAndIncrement();
        }
    };

    @Test
    public void alarm_01() {
        AlarmClock alarmClock = new AlarmClock();
        alarmClock.add(this.callback, 10000000L);
        alarmClock.cancel(this.callback);
        TestAlarmClock.assertEquals((long)0L, (long)this.count.get());
        alarmClock.release();
    }

    @Test
    public void alarm_02() {
        AlarmClock alarmClock = new AlarmClock();
        alarmClock.add(this.callback, 10L);
        Lib.sleep((int)150);
        TestAlarmClock.assertEquals((long)1L, (long)this.count.get());
        alarmClock.cancel(this.callback);
        alarmClock.release();
    }

    @Test
    public void alarm_03() {
        AlarmClock alarmClock = new AlarmClock();
        alarmClock.add(this.callback, 10L);
        alarmClock.add(this.callback, 1000000L);
        Lib.sleep((int)150);
        TestAlarmClock.assertEquals((long)1L, (long)this.count.get());
        alarmClock.cancel(this.callback);
        alarmClock.release();
    }

    @Test
    public void alarm_04() {
        AlarmClock alarmClock = new AlarmClock();
        alarmClock.add(this.callback, 10L);
        alarmClock.add(this.callback, 20L);
        Lib.sleep((int)200);
        TestAlarmClock.assertEquals((long)2L, (long)this.count.get());
        alarmClock.release();
    }

    @Test
    public void alarm_05() {
        AlarmClock alarmClock = new AlarmClock();
        alarmClock.add(this.callback, 1000L);
        alarmClock.reset(this.callback, 2000L);
        Lib.sleep((int)50);
        TestAlarmClock.assertEquals((long)0L, (long)this.count.get());
        alarmClock.release();
    }
}

