/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.ListUtils;
import org.junit.Test;

public class TestListUtils
extends BaseTest {
    @Test
    public void list01() {
        List x = Arrays.asList(1, 2, 3);
        x = ListUtils.unique(x);
        TestListUtils.assertEquals((long)3L, (long)x.size());
        this.test(x, 1, 2, 3);
    }

    @Test
    public void list02() {
        List x = Arrays.asList(1, 2, 3, 1, 3, 2);
        x = ListUtils.unique(x);
        TestListUtils.assertEquals((long)3L, (long)x.size());
        this.test(x, 1, 2, 3);
    }

    @Test
    public void list03() {
        List<Integer> x = new ArrayList();
        x = ListUtils.unique(x);
        TestListUtils.assertEquals((long)0L, (long)x.size());
        this.test(x, new int[0]);
    }

    @Test
    public void list04() {
        List x = Arrays.asList(99);
        x = ListUtils.unique(x);
        TestListUtils.assertEquals((long)1L, (long)x.size());
        this.test(x, 99);
    }

    @Test
    public void list05() {
        List x = Arrays.asList(1, 1, 2, 3, 1, 1, 3);
        x = ListUtils.unique(x);
        TestListUtils.assertEquals((long)3L, (long)x.size());
        this.test(x, 1, 2, 3);
    }

    private void test(List<Integer> x, int ... args) {
        TestListUtils.assertEquals((long)args.length, (long)x.size());
        for (int i = 0; i < args.length; ++i) {
            TestListUtils.assertEquals((long)args[i], (long)x.get(i).intValue());
        }
    }
}

