/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.ReverseComparator;
import org.junit.Test;

public class TestReverseComparator
extends BaseTest {
    static Comparator<String> normal = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    static Comparator<String> reverse = new ReverseComparator(normal);
    static Comparator<String> maxMin = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int value = o1.compareTo(o2);
            if (value > 0) {
                return Integer.MAX_VALUE;
            }
            if (value < 0) {
                return Integer.MIN_VALUE;
            }
            return 0;
        }
    };
    static Comparator<String> reverseMaxMin = new ReverseComparator(maxMin);
    static List<String> items = Arrays.asList("a", "b", "c", "d");
    static List<String> itemsReverse = Arrays.asList("d", "c", "b", "a");

    @Test
    public void reverse_01() {
        ArrayList<String> modified = new ArrayList<String>(items);
        Collections.sort(modified, reverse);
        this.test(itemsReverse, modified);
    }

    @Test
    public void reverse_02() {
        ArrayList<String> modified = new ArrayList<String>(items);
        Collections.sort(modified, reverseMaxMin);
        this.test(itemsReverse, modified);
    }

    private void test(List<?> expected, List<?> actual) {
        TestReverseComparator.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestReverseComparator.assertEquals(expected.get(i), actual.get(i));
        }
    }
}

