/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.SetUtils;
import org.junit.Test;

public class TestSetUtils
extends BaseTest {
    @Test
    public void set01() {
        Set<Integer> x = TestSetUtils.set(1, 2, 3);
        this.test(x, 1, 2, 3);
    }

    @Test
    public void set02() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(1, 2, 3);
        Set x3 = SetUtils.intersection(x1, x2);
        this.test(x3, 1, 2, 3);
        x3 = SetUtils.intersection(x2, x1);
        this.test(x3, 1, 2, 3);
    }

    @Test
    public void set03() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(2, 9);
        Set x3 = SetUtils.intersection(x1, x2);
        this.test(x3, 2);
        x3 = SetUtils.intersection(x2, x1);
        this.test(x3, 2);
    }

    @Test
    public void set04() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(6, 7, 8);
        Set x3 = SetUtils.intersection(x1, x2);
        this.test(x3, new int[0]);
        x3 = SetUtils.intersection(x2, x1);
        this.test(x3, new int[0]);
    }

    @Test
    public void set05() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(1, 2, 3);
        Set x3 = SetUtils.union(x1, x2);
        this.test(x3, 1, 2, 3);
        x3 = SetUtils.union(x2, x1);
        this.test(x3, 1, 2, 3);
    }

    @Test
    public void set06() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(2, 9);
        Set x3 = SetUtils.union(x1, x2);
        this.test(x3, 1, 2, 3, 9);
        x3 = SetUtils.union(x2, x1);
        this.test(x3, 1, 2, 3, 9);
    }

    @Test
    public void set07() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(new int[0]);
        Set x3 = SetUtils.union(x1, x2);
        this.test(x3, 1, 2, 3);
        x3 = SetUtils.union(x2, x1);
        this.test(x3, 1, 2, 3);
    }

    @Test
    public void set08() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(new int[0]);
        Set x3 = SetUtils.difference(x1, x2);
        this.test(x3, 1, 2, 3);
        x3 = SetUtils.difference(x2, x1);
        this.test(x3, new int[0]);
    }

    @Test
    public void set09() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(3);
        Set x3 = SetUtils.difference(x1, x2);
        this.test(x3, 1, 2);
        x3 = SetUtils.difference(x2, x1);
        this.test(x3, new int[0]);
    }

    @Test
    public void set10() {
        Set<Integer> x1 = TestSetUtils.set(1, 2, 3);
        Set<Integer> x2 = TestSetUtils.set(4, 5, 6);
        Set x3 = SetUtils.difference(x1, x2);
        this.test(x3, 1, 2, 3);
        x3 = SetUtils.difference(x2, x1);
        this.test(x3, 4, 5, 6);
    }

    private static Set<Integer> set(int ... values) {
        return new HashSet<Integer>(ListUtils.asList((int[])values));
    }

    private void test(Set<Integer> x, int ... values) {
        List y = ListUtils.asList((int[])values);
        TestSetUtils.assertEquals((long)y.size(), (long)x.size());
        for (Integer aY : y) {
            TestSetUtils.assertTrue((boolean)x.contains(aY));
        }
    }
}

