/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.adapters.RDFReaderFactoryRIOT;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJenaReaderRIOT
extends BaseTest {
    private static final String directory = "testing/RIOT/Reader";
    private static Context context = new Context();

    @BeforeClass
    public static void beforeClass() {
        RIOT.init();
    }

    @AfterClass
    public static void afterClass() {
    }

    @Test
    public void read_01() {
        TestJenaReaderRIOT.jenaread("D.nt");
    }

    @Test
    public void read_02() {
        TestJenaReaderRIOT.jenaread("D.ttl");
    }

    @Test
    public void read_03() {
        TestJenaReaderRIOT.jenaread("D.rdf");
    }

    @Test
    public void read_04() {
        TestJenaReaderRIOT.jenaread("D.rdf");
    }

    @Test
    public void read_05() {
        TestJenaReaderRIOT.jenaread("D.json");
    }

    @Test
    public void read_11() {
        TestJenaReaderRIOT.jenaread("D.nt", "N-TRIPLES");
    }

    @Test
    public void read_12() {
        TestJenaReaderRIOT.jenaread("D.ttl", "TTL");
    }

    @Test
    public void read_13() {
        TestJenaReaderRIOT.jenaread("D.rdf", "RDF/XML");
    }

    @Test
    public void read_14() {
        TestJenaReaderRIOT.jenaread("D.rdf", "RDF/XML-ABBREV");
    }

    @Test
    public void read_15() {
        TestJenaReaderRIOT.jenaread("D.json", "RDF/JSON");
    }

    @Test
    public void read_21a() {
        TestJenaReaderRIOT.jenaread("D-nt", "N-TRIPLES");
    }

    @Test
    public void read_21b() {
        TestJenaReaderRIOT.jenaread("D-nt", "NTRIPLES");
    }

    @Test
    public void read_21c() {
        TestJenaReaderRIOT.jenaread("D-nt", "NT");
    }

    @Test
    public void read_21d() {
        TestJenaReaderRIOT.jenaread("D-nt", "N-Triples");
    }

    @Test
    public void read_22a() {
        TestJenaReaderRIOT.jenaread("D-ttl", "TURTLE");
    }

    @Test
    public void read_22b() {
        TestJenaReaderRIOT.jenaread("D-ttl", "TTL");
    }

    @Test
    public void read_23a() {
        TestJenaReaderRIOT.jenaread("D-rdf", "RDF/XML");
    }

    @Test
    public void read_23b() {
        TestJenaReaderRIOT.jenaread("D-rdf", "RDFXML");
    }

    @Test
    public void read_24() {
        TestJenaReaderRIOT.jenaread("D-json", "RDF/JSON");
    }

    @Test
    public void read_30() {
        TypedInputStream in = RDFDataMgr.open((String)TestJenaReaderRIOT.filename("D-not-TTL.ttl"));
        Model m0 = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m0, (InputStream)in, (Lang)RDFLanguages.RDFXML);
        TypedInputStream in1 = RDFDataMgr.open((String)TestJenaReaderRIOT.filename("D-not-TTL.ttl"));
        Model m1 = ModelFactory.createDefaultModel();
        m1.read((InputStream)in1, null, "RDF/XML");
    }

    @Test
    public void read_StringReader_31() {
        String x = "<s> <p> <p> .";
        StringReader s = new StringReader(x);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (StringReader)s, null, (Lang)RDFLanguages.NTRIPLES);
        StringReader s1 = new StringReader("<s> <p> <p> .");
        Model m1 = ModelFactory.createDefaultModel();
        m1.read((Reader)s1, null, "N-TRIPLES");
    }

    @Test
    public void read_StringReader_32() {
        String x = StrUtils.strjoinNL((String[])new String[]{"<rdf:RDF", "   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", "   xmlns:j.0=\"http://example/\">", "  <rdf:Description rdf:about=\"http://example/s\">", "     <j.0:p rdf:resource=\"http://example/o\"/>", "   </rdf:Description>", "</rdf:RDF>"});
        StringReader s = new StringReader(x);
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (StringReader)s, null, (Lang)RDFLanguages.RDFXML);
        StringReader s1 = new StringReader(x);
        m = ModelFactory.createDefaultModel();
        m.read((Reader)s1, null, "RDF/XML");
    }

    @Test
    public void read_base_1() {
        TestJenaReaderRIOT.jenaread("D-no-base.ttl", "TTL", "http://baseuri/");
    }

    @Test
    public void read_input_1() throws IOException {
        TestJenaReaderRIOT.jenaread_stream("D.ttl", "TTL");
    }

    @Test
    public void read_input_2() throws IOException {
        TestJenaReaderRIOT.jenaread_stream("D.rdf", "RDF/XML");
    }

    private static String filename(String filename) {
        return "testing/RIOT/Reader/" + filename;
    }

    private static void jenaread_stream(String filename, String lang) throws IOException {
        filename = TestJenaReaderRIOT.filename(filename);
        try (FileInputStream in0 = new FileInputStream(filename);){
            Model m0 = ModelFactory.createDefaultModel();
            RDFDataMgr.read((Model)m0, (InputStream)in0, (String)"http://example/base2", (Lang)RDFLanguages.nameToLang((String)lang));
        }
        var3_3 = null;
        try (FileInputStream in1 = new FileInputStream(filename);){
            Model m1 = ModelFactory.createDefaultModel();
            RDFDataMgr.read((Model)m1, (InputStream)in1, (Lang)RDFLanguages.nameToLang((String)lang));
        }
        catch (Throwable x2) {
            var3_3 = x2;
            throw x2;
        }
        Model m2 = ModelFactory.createDefaultModel();
        try (FileInputStream in2 = new FileInputStream(filename);){
            m2.read((InputStream)in2, "http://example/base3", lang);
        }
        String x = FileUtils.readWholeFileAsUTF8((String)filename);
        Model m3 = ModelFactory.createDefaultModel();
        m2.read((Reader)new StringReader(x), "http://example/base4", lang);
    }

    private static void jenaread(String dataurl) {
        dataurl = TestJenaReaderRIOT.filename(dataurl);
        Model m = ModelFactory.createDefaultModel();
        m.read(dataurl);
        TestJenaReaderRIOT.assertTrue((m.size() != 0L ? 1 : 0) != 0);
    }

    private static void jenaread(String dataurl, String lang) {
        dataurl = TestJenaReaderRIOT.filename(dataurl);
        Model m0 = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m0, (String)dataurl, (Lang)RDFLanguages.nameToLang((String)lang));
        TestJenaReaderRIOT.assertTrue((m0.size() != 0L ? 1 : 0) != 0);
        Model m1 = ModelFactory.createDefaultModel();
        new RDFReaderFactoryRIOT().getReader(lang).read(m1, dataurl);
        TestJenaReaderRIOT.assertTrue((m1.size() != 0L ? 1 : 0) != 0);
        Model m2 = ModelFactory.createDefaultModel();
        String x = RDFLanguages.nameToLang((String)lang).getName();
        m2.read(dataurl, x);
        TestJenaReaderRIOT.assertTrue((m2.size() != 0L ? 1 : 0) != 0);
    }

    private static void jenaread(String dataurl, String lang, String base) {
        dataurl = TestJenaReaderRIOT.filename(dataurl);
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m1, (String)dataurl, (String)base, (Lang)RDFLanguages.nameToLang((String)lang));
        m2.read("file:" + dataurl, base, lang);
        TestJenaReaderRIOT.assertTrue((m1.size() != 0L ? 1 : 0) != 0);
        TestJenaReaderRIOT.assertTrue((m2.size() != 0L ? 1 : 0) != 0);
        TestJenaReaderRIOT.assertTrue((boolean)m1.isIsomorphicWith(m2));
        Resource s = ((Statement)m1.listStatements().next()).getSubject();
        TestJenaReaderRIOT.assertTrue((boolean)s.getURI().startsWith("http://"));
        TestJenaReaderRIOT.assertTrue((boolean)s.getURI().equals("http://baseuri/s"));
    }
}

