/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.StringReader;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.IRIResolver;
import org.junit.Test;

public class TestLangCSV
extends BaseTest {
    private static final String FILE_NAME = "src/test/resources/test.csv";
    private static final String FILE_URI = IRIResolver.resolveString((String)"src/test/resources/test.csv");

    @Test
    public void testPredicateWithSpace() {
        String[] s1 = new String[]{"Predicate With Space", "PredicateWithSpace"};
        String[] s2 = new String[]{" [] <" + FILE_URI + "#Predicate%20With%20Space> 'PredicateWithSpace' ; ", " <http://w3c/future-csv-vocab/row> 1 ."};
        this.assertIsomorphicWith(s1, s2);
    }

    @Test
    public void testNonURICharacters() {
        String[] s1 = new String[]{"`~!@#$%^&*()-_=+[{]}|\\;:'\"<.>/?", "NonURICharacters"};
        String[] s2 = new String[]{" [] <" + FILE_URI + "#%60~%21%40%23%24%25%5E%26%2A%28%29-_%3D%2B%5B%7B%5D%7D%7C%5C%3B%3A%27%22%3C.%3E%2F%3F> 'NonURICharacters' ; ", " <http://w3c/future-csv-vocab/row> 1 ."};
        this.assertIsomorphicWith(s1, s2);
    }

    @Test
    public void testDigitalLocalName() {
        String[] s1 = new String[]{"1234", "DigitalLocalName"};
        String[] s2 = new String[]{" [] <" + FILE_URI + "#1234> 'DigitalLocalName' ; ", " <http://w3c/future-csv-vocab/row> 1 ."};
        this.assertIsomorphicWith(s1, s2);
    }

    @Test
    public void testMoney() {
        String[] s1 = new String[]{"\u00a3", "\u00a3"};
        String[] s2 = new String[]{" [] <" + FILE_URI + "#%A3> '\u00a3' ; ", " <http://w3c/future-csv-vocab/row> 1 ."};
        this.assertIsomorphicWith(s1, s2);
    }

    @Test
    public void RDFDataMgrReadTest() {
        Model m1 = RDFDataMgr.loadModel((String)FILE_NAME, (Lang)RDFLanguages.CSV);
        Model m2 = ModelFactory.createDefaultModel();
        m2.read(FILE_NAME, "CSV");
        TestLangCSV.assertEquals((long)12L, (long)m1.size());
        TestLangCSV.assertTrue((boolean)m1.isIsomorphicWith(m2));
    }

    private Model parseToModel(String[] strings, Lang lang) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        StringReader r = new StringReader(string);
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (StringReader)r, (String)FILE_NAME, (Lang)lang);
        return model;
    }

    private void assertIsomorphicWith(String[] s1, String[] s2) {
        Model m1 = this.parseToModel(s1, RDFLanguages.CSV);
        Model m2 = this.parseToModel(s2, RDFLanguages.TURTLE);
        TestLangCSV.assertTrue((boolean)m1.isIsomorphicWith(m2));
    }
}

