/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.langsuite;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.util.junit.TestFactoryManifest;
import com.hp.hpl.jena.util.junit.TestUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.langsuite.UnitTestBadEval;
import org.apache.jena.riot.langsuite.UnitTestBadSyntax;
import org.apache.jena.riot.langsuite.UnitTestEval;
import org.apache.jena.riot.langsuite.UnitTestSurpressed;
import org.apache.jena.riot.langsuite.UnitTestSyntax;
import org.apache.jena.riot.langsuite.VocabLangRDF;

public class FactoryTestRiot
extends TestFactoryManifest {
    public static String assumedRootURIex = "http://example/base/";
    public static String assumedRootURITurtle = "http://www.w3.org/2013/TurtleTests/";
    public static String assumedRootURITriG = "http://www.w3.org/2013/TriGTests/";
    public static EarlReport report = null;
    private Resource dftTestType;
    private String labelPrefix;

    public static TestSuite make(String manifest, Resource dftTestType, String labelPrefix) {
        return new FactoryTestRiot(dftTestType, labelPrefix).process(manifest);
    }

    public FactoryTestRiot(Resource dftTestType, String labelPrefix) {
        this.dftTestType = dftTestType;
        this.labelPrefix = labelPrefix;
    }

    public Test makeTest(Resource manifest, Resource item, String testName, Resource action, Resource result) {
        try {
            Resource r = TestUtils.getResource((Resource)item, (Property)RDF.type);
            if (r == null) {
                r = this.dftTestType;
            }
            if (r == null) {
                throw new RiotException("Can't determine the test type");
            }
            if (this.labelPrefix != null) {
                testName = this.labelPrefix + testName;
            }
            Resource input = action;
            Resource output = result;
            if (r.equals((Object)VocabLangRDF.TestPositiveSyntaxTTL)) {
                return new UnitTestSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.TURTLE, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeSyntaxTTL)) {
                return new UnitTestBadSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.TURTLE, report);
            }
            if (r.equals((Object)VocabLangRDF.TestPositiveSyntaxTriG)) {
                return new UnitTestSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.TRIG, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeSyntaxTriG)) {
                return new UnitTestBadSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.TRIG, report);
            }
            if (r.equals((Object)VocabLangRDF.TestPositiveSyntaxNT)) {
                return new UnitTestSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.NTRIPLES, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeSyntaxNT)) {
                return new UnitTestBadSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.NTRIPLES, report);
            }
            if (r.equals((Object)VocabLangRDF.TestPositiveSyntaxNQ)) {
                return new UnitTestSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.NQUADS, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeSyntaxNQ)) {
                return new UnitTestBadSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.NQUADS, report);
            }
            if (r.equals((Object)VocabLangRDF.TestPositiveSyntaxRJ)) {
                return new UnitTestSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.RDFJSON, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeSyntaxRJ)) {
                return new UnitTestBadSyntax(testName, item.getURI(), input.getURI(), RDFLanguages.RDFJSON, report);
            }
            if (r.equals((Object)VocabLangRDF.TestSurpressed)) {
                return new UnitTestSurpressed(testName, item.getURI(), report);
            }
            if (r.equals((Object)VocabLangRDF.TestEvalTTL)) {
                String base = FactoryTestRiot.rebase(input, assumedRootURITurtle);
                return new UnitTestEval(testName, item.getURI(), input.getURI(), result.getURI(), base, RDFLanguages.TURTLE, report);
            }
            if (r.equals((Object)VocabLangRDF.TestEvalTriG)) {
                String base = FactoryTestRiot.rebase(input, assumedRootURITriG);
                return new UnitTestEval(testName, item.getURI(), input.getURI(), result.getURI(), base, RDFLanguages.TRIG, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeEvalTTL)) {
                return new UnitTestBadEval(testName, item.getURI(), input.getURI(), RDFLanguages.TURTLE, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeEvalTriG)) {
                return new UnitTestBadEval(testName, item.getURI(), input.getURI(), RDFLanguages.TRIG, report);
            }
            if (r.equals((Object)VocabLangRDF.TestEvalNT)) {
                return new UnitTestEval(testName, item.getURI(), input.getURI(), result.getURI(), null, RDFLanguages.NTRIPLES, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeEvalNT)) {
                return new UnitTestBadEval(testName, item.getURI(), input.getURI(), RDFLanguages.NTRIPLES, report);
            }
            if (r.equals((Object)VocabLangRDF.TestEvalRJ)) {
                String base = FactoryTestRiot.rebase(input, assumedRootURIex);
                return new UnitTestEval(testName, item.getURI(), input.getURI(), result.getURI(), base, RDFLanguages.RDFJSON, report);
            }
            if (r.equals((Object)VocabLangRDF.TestNegativeEvalRJ)) {
                return new UnitTestBadEval(testName, item.getURI(), input.getURI(), RDFLanguages.RDFJSON, report);
            }
            System.err.println("Unrecognized turtle test : (" + r + ")" + testName);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Failed to grok test : " + testName);
            return null;
        }
    }

    private static String rebase(Resource input, String baseIRI) {
        String x = input.getLocalName();
        baseIRI = baseIRI + x;
        return baseIRI;
    }
}

