/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.langsuite;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.langsuite.LangTestCase;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.junit.After;
import org.junit.Before;

public class UnitTestBadEval
extends LangTestCase {
    private final String input;
    private final Lang lang;
    protected ErrorHandler installed;

    protected UnitTestBadEval(String name, String testURI, String uri, Lang lang, EarlReport earl) {
        super(name, testURI, earl);
        this.input = uri;
        this.lang = lang;
    }

    @Override
    @Before
    public void _setUp() {
        this.installed = ErrorHandlerFactory.getDefaultErrorHandler();
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerStrictSilent());
    }

    @Override
    @After
    public void _tearDown() {
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)this.installed);
    }

    @Override
    public void runTestForReal() {
        if (RDFLanguages.isTriples((Lang)this.lang)) {
            this.run3();
        } else {
            this.run4();
        }
    }

    private void run3() {
        Model model = ModelFactory.createDefaultModel();
        try {
            RDFDataMgr.read((Model)model, (String)this.input);
            UnitTestBadEval.fail((String)"Managed to read a bad evaluation test without error");
        }
        catch (JenaException ex) {
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    private void run4() {
        Dataset ds = DatasetFactory.createMem();
        try {
            RDFDataMgr.read((Dataset)ds, (String)this.input);
            UnitTestBadEval.fail((String)"Managed to read a bad evaluation test without error");
        }
        catch (JenaException ex) {
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }
}

