/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import java.io.File;
import org.apache.jena.atlas.junit.BaseTest;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.junit.Test;

public class TestLocators
extends BaseTest {
    public static final String testingDir = "testing/RIOT/Files/";

    @Test
    public void locatorFile_01() {
        LocatorFile loc = new LocatorFile();
        TestLocators.assertTrue((boolean)loc.exists("pom.xml"));
        TestLocators.assertTrue((boolean)loc.exists("testing/RIOT/Files/data.ttl"));
        TestLocators.assertFalse((boolean)loc.exists("IDoNotExist"));
    }

    @Test
    public void locatorFile_02() {
        LocatorFile loc = new LocatorFile(".");
        TestLocators.assertTrue((boolean)loc.exists("pom.xml"));
        TestLocators.assertTrue((boolean)loc.exists("testing/RIOT/Files/data.ttl"));
        TestLocators.assertFalse((boolean)loc.exists("IDoNotExist"));
    }

    @Test
    public void locatorFile_03() {
        String dir = new File(".").getAbsolutePath();
        LocatorFile loc = new LocatorFile(dir);
        TestLocators.assertTrue((boolean)loc.exists("pom.xml"));
        TestLocators.assertFalse((boolean)loc.exists("IDoNotExist"));
    }

    @Test
    public void locatorFile_04() {
        String dir = new File("src").getAbsolutePath();
        LocatorFile loc = new LocatorFile(dir);
        TestLocators.assertFalse((boolean)loc.exists("pom.xml"));
        TestLocators.assertTrue((boolean)loc.exists("main"));
        TestLocators.assertFalse((boolean)loc.exists("testing/RIOT/Files/data.ttl"));
        TestLocators.assertTrue((boolean)loc.exists("../pom.xml"));
        TestLocators.assertFalse((boolean)loc.exists("/../testing/RIOT/Files/data.ttl"));
    }

    @Test
    public void locatorFile_05() {
        LocatorFile loc = new LocatorFile();
        TypedInputStream ts = loc.open("testing/RIOT/Files/data.ttl");
        TestLocators.assertTrue((String)("Not equal: text/turtle != " + ts.getMediaType()), (boolean)"text/turtle".equalsIgnoreCase(ts.getContentType()));
    }

    @Test
    public void locatorURL_01() {
    }

    @Test
    public void locatorZip_01() {
    }

    @Test
    public void locatorClassloader_01() {
    }
}

